;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Rgc/accept.scm ...       */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Thu May 30 09:46:36 1991                          */
;*    Last change :  Fri Mar 19 07:01:03 1993  (serrano)               */
;*                                                                     */
;*    Quelles sont les transitions acceptantes ?                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module rgc_automata_accept
   (export (make-accept-function nb-states states)))

;*---------------------------------------------------------------------*/
;*     make-accept-function ...                                        */
;*---------------------------------------------------------------------*/
(define (make-accept-function nb-states states)
   (let ((t-state-type    (make-vector nb-states '()))
	 (accept-action*  'dummy)
	 (leave-out?      'dummy))
;*---- accept?    -----------------------------------------------------*/
;*   Cette fonction fait deux effets de bords:                         */
;*      - un sur accept-action*                                        */
;*      - un sur leave-out?                                            */
;*---------------------------------------------------------------------*/
      (lambda fun
	 (case (car fun)
	    ((leave-out?)
	     leave-out?)
	    (else
	     (let ((state-num (car fun)))
		;; a-t-on deja calcule les caracteristiques de cet etat?
		(let ((ref (vector-ref t-state-type state-num)))
		   (if (not (null? ref))
		       ;; oui
		       (begin
			  (set! accept-action* (car ref))
			  (set! leave-out?     (cdr ref))
			  accept-action*)
		       ;; non
		       (begin
			  (set! accept-action* '())
			  (set! leave-out? #f)
			  (let loop ((t* (vector-ref states state-num)))
			     (if (null? t*)
				 (begin
				    (vector-set! t-state-type 
						 state-num 
						 (cons accept-action*
						       leave-out?))
				    accept-action*)
				 (let ((pr* (car t*)))
				    (if (not (char? (car pr*)))
					;; Oui, cet etat est accepte pr*
					(for-each
					 (lambda (ok)
					    (set!
					     accept-action* 
					     (insort! ok
						      accept-action*)))
					 pr*)
					;; Cet etat est leave-out
					(set! leave-out? #t))
				    (loop (cdr t*))))))))))))))

;*---------------------------------------------------------------------*/
;*     insort! ...                                                     */
;*---------------------------------------------------------------------*/
(define (insort! quoi dans)
   (cond 
      ((null? dans) 
       (cons quoi '()))
      ((>fx quoi (car dans)) 
       (set-cdr! dans (insort! quoi (cdr dans)))
       dans)
      (else
       (set-cdr! dans (cons (car dans) (cdr dans)))
       (set-car! dans quoi)
       dans)) )
