;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Read/src.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 14:59:57 1993                          */
;*    Last change :  Wed Mar 31 09:59:03 1993  (serrano)               */
;*                                                                     */
;*    On lit le code a compiler.                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_src
   (include "Tools/trace.sch")
   (export  (read-src))
   (import  tools_speek
	    engine_param
	    engine_engine
	    var_env
	    parse_module))

;*---------------------------------------------------------------------*/
;*    read-src ...                                                     */
;*---------------------------------------------------------------------*/
(define (read-src)
   (let* ((port (if (string? *src*)
		    (if (file-exists? *src*)
			(let ((port (open-input-file *src*)))
			   (if (input-port? port)
			       port
			       (error "src-file->memory"
				      "Can't open such file"
				      *src*)))
			(error "src-file->memory"
			       "Can't find such file"
			       *src*))
		    (current-input-port)))
	  (handler (lambda (escape proc mes obj)
		      (hello-world)
		      (notify-error proc mes obj)
		      (dump-lambda-stack)
		      (input-port-display-error port (current-error-port))
		      (close-input-port port)
		      (exit -3))))
      (let (module body)
	 (try (begin (set! module (read port))
		     (set! body   (read-file port)))
	      handler)
	 (let ((module-body (parse-module module)))
	    ;; on imprime *Genv* maintenant qu'on a parse la declaration
	    ;; de module
	    (when-trace '(env read)
			(lambda ()
			   (fprint *trace-port* "==> Genv (parse-module): ")
			   (pp-global-environment *trace-port* *Genv*)))
	    ;; parse-module retourne du code dans le cas ou
	    ;; on inclus des fichiers.
	    (append module-body body)))))

;*---------------------------------------------------------------------*/
;*    read-file ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-file port)
   (let loop ((r   (read port))
	      (acc '()))
      (if (eof-object? r)
	  (begin
	     (set! acc (reverse! acc))
	     (trace read
		    "--------- Le corps Lu est ------------------ "
		    #\Newline acc #\newline
		    "-------------------------------------------- "
		    #\Newline)
	     acc)
	  (loop (read port) (cons r acc)))))
