;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Read/include.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 15:41:14 1993                          */
;*    Last change :  Mon Jun 21 14:57:43 1993  (serrano)               */
;*                                                                     */
;*    On lit des fichiers `include'                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module read_include
   (import expand_eps
	   tools_speek)
   (export (read-include file)))

;*---------------------------------------------------------------------*/
;*    read-include ...                                                 */
;*    name --> < import x include x sexp >                             */
;*---------------------------------------------------------------------*/
(define (read-include file)
   (verbose "      [reading include file " file "]" #\Newline)
   (let ((port (open-input-file file)))
      (if (not (input-port? port))
	  (error "read-include" "Can't open such file" file)
	  (let ((handler (lambda (escape proc mes obj)
			    (notify-error proc mes obj)
			    (input-port-display-error port
						      (current-error-port))
			    (fprint (current-error-port) "(file " file ")")
			    (close-input-port port)
			    (exit -3))))
	     (try (let loop ((r       (read port))
			     (import  '())
			     (include '())
			     (sexp    '()))
		     (if (eof-object? r)
			 (begin
			    (close-input-port port)
			    (list import include (reverse! sexp)))
			 (match-case r
			    ((define-macro . ?-)
			     (add-macro! r)
			     (loop (read port)
				   import
				   include
				   sexp))
			    ((define-expander . ?-)
			     (add-macro! r)
			     (loop (read port)
				   import
				   include
				   sexp))
			    ((import . ?rest)
			     (loop (read port)
				   (append rest import)
				   include
				   sexp))
			    ((include ?file)
			     (loop (read port)
				   import
				   (cons file include)
				   sexp))
			    (else
			     (loop (read port)
				   import
				   include
				   (cons r sexp))))))
		     handler)))))
