;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../statexp.scm ...                                              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 15:57:09 1993                          */
;*    Last change :  Wed May  5 09:20:58 1993  (serrano)               */
;*                                                                     */
;*    On parse les clauses d'exportations et statics                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_statexp
   (import tools_args
	   type_name
	   var_declare
	   engine_param)
   (export (parse-export exports)
	   (parse-static exports)
	   (parse-main main)))

;*---------------------------------------------------------------------*/
;*    parse-export ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-export exports)
   (let loop ((exports exports))
      (if (null? exports)
	  '()
	  (begin
	     (generic-parser (car exports) 'export)
	     (loop (cdr exports)))))))

;*---------------------------------------------------------------------*/
;*    parse-static ...                                                 */
;*---------------------------------------------------------------------*/
(define (parse-static statics)
    (let loop ((statics statics))
      (if (null? statics)
	  '()
	  (begin
	     (generic-parser (car statics) 'static)
	     (loop (cdr statics)))))))
  
;*---------------------------------------------------------------------*/
;*    generic-parser ...                                               */
;*---------------------------------------------------------------------*/
(define (generic-parser prototype import)
   (match-case prototype
      ((inline ?name . ?args)
       (declare-global-inline! name args *module-name* import))
      ((?name . ?args)
       (declare-global-procedure! name args *module-name* import))
      ((and (not (?- . ?-)) ?name)
       (declare-global-variable! name *module-name* import))
      (else
       (error "generic-parser" "Illegal prototype" prototype))))


;*---------------------------------------------------------------------*/
;*    parse-main ...                                                   */
;*---------------------------------------------------------------------*/
(define (parse-main main)
   (if main
       (add-to-remember-list! main)))
