;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../include.scm ...                                              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 16 17:13:18 1992                          */
;*    Last change :  Wed Mar 17 15:45:46 1993  (serrano)               */
;*                                                                     */
;*    On parse les fichiers includes                                   */
;*    -------------------------------------------------------------    */
;*    Un fichier include contient:                                     */
;*       - des macros                                                  */
;*       - des structures                                              */
;*       - des directives d'importations                               */
;*       - des includes                                                */
;*    Tout le reste doit etre considere comme errone                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_include
   (import read_include)
   (export (parse-include files)))

;*---------------------------------------------------------------------*/
;*    parse-include ...                                                */
;*    name --> import x scheme                                         */
;*---------------------------------------------------------------------*/
(define (parse-include files)
   (let loop ((files   files)
	      (import  '())
	      (body    '()))
      (if (null? files)
	  (cons import body)
	  (let ((imp.inc.sexp (read-include (car files))))
	     (loop (if (null? (cdr files))
		       (cadr imp.inc.sexp)
		       (if (null? (cadr imp.inc.sexp))
			   (cdr files)
			   (cons (cadr imp.inc.sexp) (cdr files))))
		   (if (null? import)
		       (car imp.inc.sexp)
		       (if (null? (car imp.inc.sexp))
			   import
			   (append (car imp.inc.sexp) import)))
		   (append (caddr imp.inc.sexp) body))))))


				   
				   
