;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Lift/walk.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 16:26:07 1993                          */
;*    Last change :  Wed Apr  7 08:34:35 1993  (serrano)               */
;*                                                                     */
;*    Le `lambda-lifting'                                              */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_walk
   (import tools_speek
	   tools_error
	   tools_shape
	   lift_definition
	   lift_init
	   var_env
	   engine_param)
   (export (lift-walk tree)))

;*---------------------------------------------------------------------*/
;*    lift-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (lift-walk tree)
   (verbose "   . Lift" #\Newline)
   (start-partial-error "Lift")
   (let ((module-init (find-in-global-environment (initialisation-name)
						  *Genv*)))
      (let loop ((walk      tree)
		 (res       '())
		 (init-form  #f))
	 (if (null? walk)
	     (begin
		(fail-if-partial-error)
		(lift-init-module! init-form)
		res)
	     (let ((var (car walk)))
		(enter-function (shape var))
		(let ((defs (lift-definition var)))
		   (leave-function)
		   (if (eq? var module-init)
		       (loop (cdr walk)
			     (append defs res)
			     (car defs))
		       (loop (cdr walk)
			     (append defs res)
			     init-form))))))))


