;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../expression.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 31 11:43:49 1993                          */
;*    Last change :  Fri Apr 16 08:17:33 1993  (serrano)               */
;*                                                                     */
;*    On lift une expression                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_expression
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    engine_param
	    heap_abstract
	    scan_lexical
	    lift_closure
	    lift_block
	    lift_labels)
   (export (lift-expression exp fun)))

;*---------------------------------------------------------------------*/
;*    lift-expression ...                                              */
;*---------------------------------------------------------------------*/
(define (lift-expression exp fun)
   (let loop ((exp exp))
      (trace (lift loop) "lift: [" (shape fun) "] " (shape exp)
	     #\Newline)
      (match-case exp
;*--- nil -------------------------------------------------------------*/
	 (()
	  exp)
;*--- atom ------------------------------------------------------------*/
	 ((atom ?-)
	  (if (and (local? exp)
		   (eq? (local-access exp) 'write)
		   (or *call/cc?* (lift-kaptured? (local-info exp))))
	      (abstract-cell-ref exp)
	      exp))
;*--- set! ------------------------------------------------------------*/
	 ((set! . ?-)
	  (trace lift "Dans set!" (shape exp) #\newline)
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (if (and (local? (cadr exp))
		   (eq? (local-access (cadr exp)) 'write)
		   (or *call/cc?* (lift-kaptured? (local-info (cadr exp)))))
	      (abstract-cell-set! exp))
	  exp)
;*--- function --------------------------------------------------------*/
	 ((function ?var)
	  (the-closure var))
;*--- quote -----------------------------------------------------------*/
	 ((quote ?-)
	  exp)
;*--- failure ---------------------------------------------------------*/
	 ((failure . ?-)
	  (set-car! (cdr exp) (loop (cadr exp)))
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (set-car! (cdddr exp) (loop (cadddr exp)))
	  exp)
;*--- cif -------------------------------------------------------------*/
	 ((cif . ?-)
	  (set-car! (cdr exp) (loop (cadr exp)))
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (set-car! (cdddr exp) (loop (cadddr exp)))
	  exp)
;*--- typed-case ------------------------------------------------------*/
	 ((typed-case ?- ?test . ?clauses)
	  (set-car! (cddr exp) (loop test))
	  (let liip ((hook clauses))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! (cdar hook) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
	 ((begin . ?body)
	  (let liip ((hook body))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
;*--- let -------------------------------------------------------------*/
	 ((let . ?-)
	  ;; on lift le body
	  (set-car! (cddr exp) (loop (caddr exp)))
	  ;; on lift les bindings
	  (let liip ((bindings (cadr exp)))
	     (if (null? bindings)
		 exp
		 (let ((binding (car bindings)))
		    (set-car! (cdr binding) (loop (cadr binding)))
		    (if (and (eq? (local-access (car binding)) 'write)
			     (or *call/cc?* (lift-kaptured? (local-info
							     (car binding)))))
			(set-car! (cdr binding) (abstract-make-cell
						 (cadr binding))))
		    (liip (cdr bindings))))))
;*--- labels ----------------------------------------------------------*/
	 ((labels . ?-)
	  (lift-labels exp fun))
;*--- block -----------------------------------------------------------*/
	 ((block . ?-)
	  (lift-block exp fun))
;*--- return-from -----------------------------------------------------*/
	 ((return-from . ?-)
	  (lift-return-from exp fun))
;*--- apply -----------------------------------------------------------*/
	 ((apply . ?-)
	  (let liip ((hook (cdr exp)))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
;*--- funcall ---------------------------------------------------------*/
	 ((funcall . ?-)
	  (lift-funcall exp fun))
;*--- application -----------------------------------------------------*/
	 (else
	  ;; on lift les arguments
	  (let liip ((hook exp))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook)))))
	  ;; on lift la forme d'appel
	  (lift-application exp)))))

;*---------------------------------------------------------------------*/
;*    lift-funcall ...                                                 */
;*---------------------------------------------------------------------*/
(define (lift-funcall exp fun)
   ;; on lift la fonction
   (set-car! (cdr exp) (lift-expression (cadr exp) fun))
   ;; on lift les arguments
   (let liip ((hook (cddr exp)))
      (if (null? hook)
	  'done
	  (begin
	     (set-car! hook (lift-expression (car hook) fun))
	     (liip (cdr hook)))))
   ;; on construit le resultat
   (if (pair? (cadr exp))
       ;; il faut allouer une variable
       (let ((clo (cdar (allocate-local-variables (list 'clo)))))
	  `(let ((,clo ,(cadr exp)))
	      (funcall ,clo ,clo ,@(cddr exp))))
       `(funcall ,(cadr exp) ,(cadr exp) ,@(cddr exp))))

;*---------------------------------------------------------------------*/
;*    lift-application ...                                             */
;*---------------------------------------------------------------------*/
(define (lift-application exp)
   (let ((fun (car exp)))
      (cond
	 ((global? fun)
	  'ok)
	 ((not (lift-G? (local-info fun)))
	  'ok)
	 ((function-escape? (local-value fun))
	  (set-cdr! exp (cons (the-closure fun)
			      (cdr exp))))
	 (else
	  (let loop ((C    (lift-kaptured (local-info fun)))
		     (hook exp))
	     (if (null? C)
		 'ok
		 (begin
		    (set-cdr! hook (cons (car C) (cdr hook)))
		    (loop (cdr C) (cdr hook)))))))
      exp))
