;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../definition.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 29 16:55:58 1993                          */
;*    Last change :  Tue Apr 27 13:13:00 1993  (serrano)               */
;*                                                                     */
;*    On fait le lambda-lifting d'une definition                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module lift_definition
   (include "Var/variable.sch"
	    "Lift/lift.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_beta
	    engine_param
	    heap_abstract
	    var_declare
	    scan_lexical
	    lift_cgraph
	    lift_integrate
	    lift_kapture
	    lift_expression
	    lift_closure
	    lift_init)
   (export (lift-definition var)))

;*---------------------------------------------------------------------*/
;*    lift-definition ...                                              */
;*---------------------------------------------------------------------*/
(define (lift-definition var)
   (trace lift
	  "========================================" #\newline
	  (shape var) #\Newline
	  "----------------------------------------" #\newline)
   (let ((formals (function-args (global-value var)))
	 (body    (function-body (global-value var))))
      ;; On fait un parcours de body pour:
      ;;    1- calculer le graphe d'appel
      ;;    2- calculer G0, l'ensemble des fonctions qui s'enfuient.
      (global-info-set! var '())
      ;; global n'a qu'une information, les locales qu'elle appelle.
      ;; on n'a donc pas besoin d'une structure pour cela
      (for-each make-local-lift! formals)
      (let* ((G0 (call-graph! body var '())) 
	     (Gn (integrate! var G0 '()))
	     (G  (append G0 Gn)))
	 (trace lift
		"G0 : " (shape G0) #\Newline
		"Gn : " (shape Gn) #\Newline)
	 (trace lift "----------------------------------------" #\newline)
	 (kapture! var body G formals)
	 (for-each unmark-bound-integrated! G)
	 (let loop ((G    G)
		    (res '()))
	    (if (null? G)
		(append (make-global-definition var
						formals
						(lift-expression body var))
			res)
		(loop (cdr G)
		      (cons
		       (if (eq? (local-class (car G)) 'function)
			   (let ((lvalue (local-value (car G))))
			      (make-local-definition (car G)
						     (function-args lvalue)
						     (lift-expression
						      (function-body lvalue)
						      (car G))))
			   (let ((lvalue (local-value (car G))))
			      (make-local-definition (car G)
						     '()
						     (lift-expression
						      (return-body lvalue)
						      (car G)))))
		       res)))))))

;*---------------------------------------------------------------------*/
;*    make-global-definition ...                                       */
;*---------------------------------------------------------------------*/
(define (make-global-definition var formals body)
   (trace lift
	  "=================================================" #\Newline
	  "make-global-definition: " (shape var) " " (shape formals) #\Newline
	  "-------------------------------------------------" #\Newline)
   (let ((gvalue (global-value var)))
      ;; on met a jour la structure function de var
      (function-body-set! gvalue (let-indirect formals body))
      (function-args-set! gvalue formals)
      (if (or (eq? (global-import var) 'export)
	      (not (null? (function-escape? (global-value var)))))
	  (let* ((env     (cdar (allocate-local-variables '(env))))
		 (new-fun (declare-global-procedure!
			   (string->symbol (string-append "_"
							  (symbol->string
							   (global-name var))))
			   (cons 'env (map local-name (function-args gvalue)))
			   (global-module var)
			   (global-import var)))
		 (nvalue  (global-value new-fun)))
	     (declare-global-closure! var new-fun)
	     ;; on met a jour la structure function de new-fun
	     (function-args-set! nvalue (cons env (function-args gvalue)))
	     (function-body-set! nvalue `(,var ,@(function-args gvalue)))
	     (list var new-fun))
	  (list var))))

;*---------------------------------------------------------------------*/
;*    make-local-definition ...                                        */
;*---------------------------------------------------------------------*/
(define (make-local-definition var formals body)
   (trace lift
	  "=================================================" #\Newline
	  "make-local-definition: " (shape var) " " (shape formals) #\Newline
	  "-------------------------------------------------" #\Newline)
   (cond
      ((eq? (local-class var) 'return)
       (make-local-C-definition var body))
      ((function-escape? (local-value var))
       (make-local-E-definition var formals body))
      (else
       (make-local-R-definition var formals body))))

;*---------------------------------------------------------------------*/
;*    make-local-C-definition ...                                      */
;*---------------------------------------------------------------------*/
(define (make-local-C-definition var body)
   (trace lift "                     : [return]" #\Newline)
   (let* ((formals   (lift-kaptured (local-info var)))
	  (continue  (the-continue var))
	  (body     `(let ((,continue (the-continuation)))
			,(beta-reduce (labels-integrates var body)
				      (list (cons var continue)))))
	  (value     (local-value var)))
      (return-args-set! value formals)
      (return-body-set! value body)
      var))
    
;*---------------------------------------------------------------------*/
;*    make-local-E-definition ...                                      */
;*---------------------------------------------------------------------*/
(define (make-local-E-definition var formals body)
   (trace lift "                     : [escape]" #\Newline)
   (let ((formals (cons (the-closure var) formals))
	 (body    (let-captured
		   var
		   (lift-kaptured (local-info var))
		   (let-indirect (function-args (local-value var))
				 (labels-integrates var body))))
	 (value   (local-value var)))
      (trace lift "                 : " (shape body) #\Newline)
      (function-args-set! value formals)
      (function-body-set! value body)
      var))

;*---------------------------------------------------------------------*/
;*    make-local-R-definition ...                                      */
;*---------------------------------------------------------------------*/
(define (make-local-R-definition var formals body)
   (trace lift "                     : [register]" #\Newline)
   (let ((formals (append (lift-kaptured (local-info var))
			  formals))
	 (body    (let-indirect (function-args (local-value var))
			 (labels-integrates var body)))
	 (value   (local-value var)))
      (function-args-set! value formals)
      (function-body-set! value body)
      var))
   
;*---------------------------------------------------------------------*/
;*    let-indirect ...                                                 */
;*---------------------------------------------------------------------*/
(define (let-indirect arg* exp)
   (trace lift "let-indirect     : " (shape arg*) #\Newline)
   (let loop ((arg*  arg*)
	      (decl* '()))
      (if (null? arg*)
	  (if (null? decl*)
	      exp
	      `(begin ,@decl* ,exp))
	  (if (and (eq? (local-access (car arg*)) 'write)
		   (or (lift-kaptured? (local-info (car arg*))) *call/cc?*))
	      (loop (cdr arg*)
		    (cons `(set! ,(car arg*) ,(abstract-make-cell (car arg*)))
			  decl*))
	      (loop (cdr arg*) decl*)))))

;*---------------------------------------------------------------------*/
;*    let-captured ...                                                 */
;*---------------------------------------------------------------------*/
(define (let-captured var kvars exp)
   (trace lift "let-captured     : " (shape kvars) #\Newline)
   (if (null? kvars)
       exp
       (let ((closure (the-closure var)))
	  (let loop ((k     kvars)
		     (i     0)
		     (decl '()))
	     (if (null? k)
		 `(let ,decl ,exp)
		 (let ((new-arg (car k)))
		    (loop (cdr k)
			  (+fx i 1)
			  (cons (list new-arg
				      (abstract-procedure-env-ref closure i))
				decl))))))))

;*---------------------------------------------------------------------*/
;*    labels-integrates ...                                            */
;*    -------------------------------------------------------------    */
;*    Il faut rajouter les definitions de toutes les fonctions qui     */
;*    ont ete deplacees. On les trouve en faisant une selection dans   */
;*    la liste des fonctions potentiellement integrables.              */
;*---------------------------------------------------------------------*/
(define (labels-integrates var body)
   (trace lift "labels-integrates: " (shape (lift-integrates (local-info var)))
	       #\Newline)
   (let loop ((integrates (lift-integrates (local-info var)))
	      (I          '()))
      (if (null? integrates)
	  (if (null? I)
	      body
	      `(labels ,(map (lambda (i)
				`(,i ,(function-args (local-value i))
				     ,(lift-expression
				       (function-body (local-value i))
				       i)))
			     I)
		  ,body))
	  (cond
	     ((lift-G? (local-info (car integrates)))
	      (loop (cdr integrates) I))
	     ((owner? var (car integrates))
	      (loop (cdr integrates) I))
	     (else
	      (loop (cdr integrates) (cons (car integrates) I)))))))

;*---------------------------------------------------------------------*/
;*    owner? ...                                                       */
;*---------------------------------------------------------------------*/
(define (owner? owner qui)
   (trace lift "owner? : " (shape owner) " " (shape qui) #\Newline)
   (if (global? qui)
       #f
       (let ((qui-owner (lift-owner (local-info qui))))
	  (if (eq? qui-owner owner)
	      #t
	      (owner? owner qui-owner)))))
