;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.2/Integ/walk.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 15 09:30:50 1993                          */
;*    Last change :  Fri Apr 16 09:19:51 1993  (serrano)               */
;*                                                                     */
;*    L'integration de fonction en vue de la generation de code C      */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    integ_definition
	    engine_param)
   (export  (integ-walk tree)))

;*---------------------------------------------------------------------*/
;*    integ-walk ...                                                   */
;*---------------------------------------------------------------------*/
(define (integ-walk tree) 
   (verbose "   . Integ" #\Newline)
   (start-partial-error "Integ")
   (let loop ((walk      tree)
	      (res       '()))
      (if (null? walk)
	  (begin
	     (fail-if-partial-error)
	     res)
	  (let ((var (car walk)))
	     (enter-function (shape var))
	     (let ((defs (integ-definition var)))
		(leave-function)
		(loop (cdr walk)
		      (append defs res)))))))

