;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../kapture.scm ...                                              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 15 16:43:17 1993                          */
;*    Last change :  Mon Apr 26 16:31:42 1993  (serrano)               */
;*                                                                     */
;*    Le calcule des variables capturees                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_kapture
   (include "Tools/trace.sch"
	    "Var/variable.sch"
	    "Integ/integ.sch")
   (import  tools_error
	    tools_shape)
   (export (get-kaptured! v b k)
	   get-new-key
	   (trace-kaptured g)))
 
;*---------------------------------------------------------------------*/
;*    get-kaptured! ...                                                */
;*---------------------------------------------------------------------*/
(define (get-kaptured! fun bottom key)
   (let ((integ (local-info fun)))
      (if (or (not (integer? (integ-key integ)))
	      (<fx (integ-key integ) bottom))
	  (integ-key-set! integ key))
      (trace (loop cgen) "get-kaptured!: " (shape fun) #\Newline
	     "         free: " (shape (integ-free integ)) #\Newline
	     "         bind: " (shape (integ-bind integ)) #\Newline
	     "         bot : " bottom #\Newline
	     "         key : " key #\Newline)
      (if (integ-kaptured integ)
	  (cons key (integ-kaptured integ))
	  (let loop ((callee           (integ-cto integ))
		     (sets-of-kaptured (list (integ-free integ)))
		     (save             key))
	     (trace (cgen loop) "callee[ " (shape fun) "]: "
		    (shape callee) #\Newline
		                "  save: " save " ... ")
	     (if (null? callee)
		 (begin
		    (trace (cgen loop) #\Newline)
		    (let ((kaptured (union key sets-of-kaptured fun)))
		       (if (>=fx save key)
			   (integ-kaptured-set! integ kaptured))
		       (cons save kaptured)))
		 (let ((c (car callee)))
		    (cond
		       ((eq? c fun)
			(trace (cgen loop) "[eq? c fun]" #\Newline)
			(loop (cdr callee)
			      sets-of-kaptured
			      save))
		       ((eq? (local-class c) 'return)
			(trace (cgen loop) "[return]" #\Newline)
			(loop (cdr callee)
			      sets-of-kaptured
			      save))
		       ((and (integer? (integ-key (local-info c)))
			     (>=fx (integ-key (local-info c)) bottom)
			     (<fx (integ-key (local-info c)) key))
			(trace (cgen loop) "[stack key]" #\Newline)
			(if (integ-kaptured (local-info c))
			    (loop (cdr callee)
				  (cons (integ-kaptured (local-info c))
					sets-of-kaptured)
				  (minfx save (integ-key (local-info c))))
			    (loop (cdr callee)
				  sets-of-kaptured
				  (minfx save (integ-key (local-info c))))))
		       (else
			(trace (cgen loop) "[je cons]" #\Newline)
			(let ((kap (get-kaptured! c bottom (get-new-key))))
			   (loop (cdr callee)
				 (cons (cdr kap) sets-of-kaptured)
				 (minfx (car kap) save)))))))))))
   
;*---------------------------------------------------------------------*/
;*    get-new-key ...                                                  */
;*---------------------------------------------------------------------*/
(define get-new-key
   (let ((key 0))
      (lambda ()
	 (set! key (+fx key 1))
	 key)))

;*---------------------------------------------------------------------*/
;*    union ...                                                        */
;*---------------------------------------------------------------------*/
(define (union key sets fun)
   (trace (cgen loop) "union: [" (shape fun) "] " (shape sets) #\Newline)
   ;; on parcours les ensembles en mettant une nouvelle cle
   (let ((new-key (get-new-key)))
      (for-each (lambda (s) (for-each (lambda (v)
					 (integ-key-set! (local-info v)
							new-key))
				      s))
		sets)
      ;; on supprime toutes les variables definies par fun
      (for-each (lambda (v)
		   (integ-key-set! (local-info v) key))
		(integ-bind (local-info fun)))
      ;; on se supprime soit meme
      (integ-key-set! (local-info fun) key)
      ;; on collecte en remettant key
      (let loop ((sets sets)
		 (res '()))
	 (if (null? sets)
	     res
	     (let liip ((s (car sets))
			(r res))
		(if (null? s)
		    (loop (cdr sets) r)
		    (if (eq? (integ-key (local-info (car s))) new-key)
			;; ok, on la prend
			(begin
			   (integ-kaptured?-set! (local-info (car s)) #t)
			   (integ-key-set! (local-info (car s)) key)
			   (cond
			      ((eq? (local-class (car s)) 'function)
			       (liip (cdr s) r))
			      (else
			       (liip (cdr s) (cons (car s) r)))))
			;; non, on ne la prend pas
			(liip (cdr s) r))))))))
   
;*---------------------------------------------------------------------*/
;*    trace-kaptured ...                                               */
;*---------------------------------------------------------------------*/
(define (trace-kaptured G)
    (when-trace 'cgen
	       (lambda ()
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
		  (fprint *trace-port* "Kapture: " #\Newline)
		  (for-each (lambda (g)
			       (let ((integ (local-info g)))
				  (fprint *trace-port*
					  " --> " (shape g) #\:
					  (shape (integ-kaptured integ)))))
			    G)
		  (fprint *trace-port* "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))))
  
