;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../expression.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 16 08:17:11 1993                          */
;*    Last change :  Thu May  6 09:48:05 1993  (serrano)               */
;*                                                                     */
;*    On integre  une expression                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module integ_expression
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Integ/integ.sch")
   (import  tools_shape
	    engine_param
	    heap_abstract
	    integ_agraph)
   (export  (integ-expression exp fun)))

;*---------------------------------------------------------------------*/
;*    integ-expression ...                                             */
;*---------------------------------------------------------------------*/
(define (integ-expression exp fun)
   (let loop ((exp exp))
      (trace (cgen loop) "integ: " (shape exp) #\Newline)
      (match-case exp
;*--- nil -------------------------------------------------------------*/
	 (()
	  exp)
;*--- atom ------------------------------------------------------------*/
	 ((atom ?-)
	  (if (and (local? exp)
		   (eq? (local-access exp) 'write)
		   (integ? (local-info exp))
		   (not *call/cc?*)
		   (integ-kaptured? (local-info exp))
		   (null? (integ-celled (local-info exp))))
	      (abstract-cell-ref exp)
	      exp))
;*--- set! ------------------------------------------------------------*/
	 ((set! . ?-)
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (if (and (local? (cadr exp))
		   (eq? (local-access (cadr exp)) 'write)
		   (not *call/cc?*)
		   (integ-kaptured? (local-info (cadr exp)))
		   (null? (integ-celled (local-info (cadr exp)))))
	      (abstract-cell-set! exp))
	  exp)
;*--- function --------------------------------------------------------*/
	 ((function ?var)
	  exp)
;*--- quote -----------------------------------------------------------*/
	 ((quote ?-)
	  exp)
;*--- failure ---------------------------------------------------------*/
	 ((failure . ?-)
	  (set-car! (cdr exp) (loop (cadr exp)))
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (set-car! (cdddr exp) (loop (cadddr exp)))
	  exp)
;*--- cif -------------------------------------------------------------*/
	 ((cif . ?-)
	  (set-car! (cdr exp) (loop (cadr exp)))
	  (set-car! (cddr exp) (loop (caddr exp)))
	  (set-car! (cdddr exp) (loop (cadddr exp)))
	  exp)
;*--- typed-case ------------------------------------------------------*/
	 ((typed-case ?- ?test . ?clauses)
	  (set-car! (cddr exp) (loop test))
	  (let liip ((hook clauses))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! (cdar hook) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
	 ((begin . ?body)
	  (let liip ((hook body))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
;*--- let -------------------------------------------------------------*/
	 ((let . ?-)
	  ;; on integ le body
	  (set-car! (cddr exp) (loop (caddr exp)))
	  ;; on integ les bindings
	  (let liip ((bindings (cadr exp)))
	     (if (null? bindings)
		 exp
		 (let ((binding (car bindings)))
		    (set-car! (cdr binding) (loop (cadr binding)))
		    (if (and (eq? (local-access (car binding)) 'write)
			     (not *call/cc?*)
			     (integ-kaptured? (local-info (car binding)))
			     (null? (integ-celled (local-info (car binding)))))
			(set-car! (cdr binding) (abstract-make-cell
						 (cadr binding))))
		    (liip (cdr bindings))))))
;*--- labels ----------------------------------------------------------*/
	 ((labels . ?-)
	  (integ-labels exp fun))
;*--- block -----------------------------------------------------------*/
	 ((block ?escape ?body)
	  (if (integ-G? (local-info escape))
	      (integ-application (list escape) escape)
	      (begin
		 (set-car! (cddr exp) (integ-expression body fun))
		 exp)))
;*--- return-from -----------------------------------------------------*/
	 ((return-from ?escape ?body)
	  (if (integ-G? (local-info escape))
	      (set-car! exp 'greturn-from))
	  (set-car! (cddr exp) (integ-expression body fun))
	  exp)
;*--- continue --------------------------------------------------------*/
	 ((continue ?escape ?body)
	  (set-car! (cddr exp) (integ-expression body fun))
	  exp)
;*--- the-continuation ------------------------------------------------*/
	 ((the-continuation)
	  exp)
;*--- apply & funcall -------------------------------------------------*/
	 (((or apply funcall) . ?-)
	  (let liip ((hook (cdr exp)))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook))))))
;*--- application -----------------------------------------------------*/
	 (else
	  ;; on integ les arguments
	  (let liip ((hook exp))
	     (if (null? hook)
		 (integ-application exp fun)
		 (begin
		    (set-car! hook (loop (car hook)))
		    (liip (cdr hook)))))))))

;*---------------------------------------------------------------------*/
;*    integ-labels ...                                                 */
;*    -------------------------------------------------------------    */
;*    On ne met que les definitions des fonctions qui sont reellement  */
;*    integrees dans fun. Les autres ont leur definition dans leur     */
;*    integrator                                                       */
;*---------------------------------------------------------------------*/
(define (integ-labels exp fun)
   (let ((labels-body (integ-expression (caddr exp) fun)))
      (let loop ((old-decls (cadr exp))
		 (new-decls '()))
	 (if (null? old-decls)
	     (if (null? new-decls)
		 labels-body 
		 `(labels ,(map (lambda (i)
				   (set-car! (cddr i) (integ-expression
						       (caddr i) fun))
				   (function-body-set! (local-value (car i))
						       (caddr i))
				   i)
				new-decls)
		     ,labels-body))
	     (let ((var (car (car old-decls))))
		(if (and (not (integ-G? (local-info var)))
			 (or (null? (integ-integrator (local-info var)))
			     (eq? (integ-integrator (local-info var)) fun)))
		    ;; on n'a pas besoin lors de cette passe de mettre dans
		    ;; des cellules d'indirection les arguments des fonctions
		    ;; qui sont setquote (s'il y a du call/cc) car c'est
		    ;; deja fait dans la passe `Lift'.
		    (loop (cdr old-decls)
			  (cons (car old-decls) new-decls))
		    (loop (cdr old-decls)
			  new-decls)))))))
	     
;*---------------------------------------------------------------------*/
;*    integ-application ...                                            */
;*---------------------------------------------------------------------*/
(define (integ-application exp fun)
   (trace cgen "integ-application: " (shape exp) " ... ")
   (let ((fun (car exp)))
      (cond
	 ((globalized? fun)
	  (trace cgen "[global]" #\Newline)
	  exp)
	 ((not (integ-G? (local-info fun)))
	  (trace cgen "[tail]" #\Newline)
	  (cons 'tailcall exp))
	 (else
	  (trace cgen "[globed]" #\Newline
		 "  kaptured: " (shape (integ-kaptured (local-info fun)))
		 #\Newline)
	  (let loop ((C    (integ-kaptured (local-info fun)))
		     (hook exp))
	     (if (null? C)
		 exp
		 (begin
		    (set-cdr! hook (cons (car C) (cdr hook)))
		    (loop (cdr C) (cdr hook)))))))))
