;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Init/setrc.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Feb 11 10:42:15 1993                          */
;*    Last change :  Wed May  5 09:16:51 1993  (serrano)               */
;*                                                                     */
;*    On lit le fichier `runtime-command'                              */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init_setrc
   (import engine_param)
   (export (setup-default-values)))

;*---------------------------------------------------------------------*/
;*    setup-default-values ...                                         */
;*---------------------------------------------------------------------*/
(define (setup-default-values)
   (if (file-exists? ".bigloorc")
       (call-with-input-file ".bigloorc" read-bigloorc)
       (let ((home (getenv "HOME")))
	  (if (> (string-length home) 0)
	      (begin
		 (let ((bigloorc (string-append home "/.bigloorc")))
		    (if (file-exists? bigloorc)
			(call-with-input-file bigloorc read-bigloorc))))))))

;*---------------------------------------------------------------------*/
;*    read-bigloorc ...                                                */
;*---------------------------------------------------------------------*/
(define (read-bigloorc port)
   (let ((grammar (regular-grammar ((blank  (in #\space #\tab #\newline)))
		     ((* blank)                  ;; les separateurs
		      (ignore))
		     (("#" (* (all)))            ;; les commentaires
		      (ignore))
		     (("on")                     ;; la position allumee
		      #t)
		     (("off")                    ;; la position eteinte
		      #f)
		     (("set")                    ;; l'affectation
		      (context 'set)
		      (ignore))
		     ((#\=)                      ;; un separateur
		      (ignore))
		     (set ("CC")                 ;; le compilo C
			  (context 'string)
			  (set! *cc* (ignore))
			  (ignore))
		     (set ("cc")                 ;; les options de cc
			  (context 'string)
			  (set! *cc-options* (ignore))
			  (ignore))
		     (set ("ld")                 ;; les options de ld
			  (context 'string)
			  (set! *ld-options* (ignore))
			  (ignore))
		     (set ("verbose")            ;; la verbosite
			  (context)
			  (set! *verbose* (ignore))
			  (ignore))
		     (set ("char")               ;; la taille des chars
			  (context 'char)
			  (set! *last-char* (ignore))
			  (context)
			  (ignore))
		     (set ("remove")             ;; supprime-t-on les aux ?
			  (context)
			  (set! *rm-c-files* (ignore))
			  (ignore))
		     (char (#\7 (* #\space) "bit")
			  127)
		     (char (#\8 (* #\space) "bit")
			  255)
		     (set ("cdebug")             ;; le debug de c
			  (context 'string)
			  (set! *c-debug-option* (ignore))
			  (ignore))
		     (set ("indent")             ;; le nom de l'indenteur
			  (context 'string)
			  (set! *indent* (ignore))
			  (ignore))
		     (set ("startup")            ;; le startup
			  (context 'string)
			  (set! *startup-file* (ignore))
			  (ignore))
		     (string (+ (out #\" #\space #\newline #\tab #\=))
 			     (context)
			     (the-string))
		     (string (#\" (* (! (<-> #\");; Les chaines de caracteres
				      (#\\ #\"))) #\")
			     (context)
			     (the-small-string))
		     (else
		      (let ((char (the-failing-char)))
			 (if (eof-object? char)
			     char
			     (error "read-bigloorc"
				    "Illegal expression in .bigloorc"
				    (the-failing-char)))))))
	 (handler (lambda (escape proc mes obj)
		     (notify-error proc mes obj)
		     (input-port-display-error port (current-error-port))
		     (exit -1))))  
      (try (let loop ((r (read/rp grammar port)))
	      (if (not (eof-object? r))
		  (begin
		     (error "read-bigloorc"
			    "Illegal expression in .bigloorc"
			    r))))
	   handler)))
		     



