;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Heap/restore.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun 23 17:04:32 1992                          */
;*    Last change :  Wed Mar 24 09:12:55 1993  (serrano)               */
;*                                                                     */
;*    On recharge un tas qui a ete construit par bigloo                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module heap_restore
   (include "Var/variable.sch")
   (import  engine_param
	    tools_speek
	    heap_compact
	    heap_abstract
	    var_env)
   (export  (restore-heap)))

;*---------------------------------------------------------------------*/
;*    restore-heap ...                                                 */
;*---------------------------------------------------------------------*/
(define (restore-heap)
   (verbose "   . Heap" #\Newline)
   (if (string? *heap-name*)
       (let* ((port    (open-input-file *heap-name*))
	      (handler (lambda (escape proc mes obj)
			  (notify-error proc mes obj)
			  (input-port-display-error port (current-error-port))
			  (close-input-port port)
			  (exit -5))))
	  (if (not (input-port? port))
	      (error "restore-heap"
		     "Can't open heap file"
		     *heap-name*)
	      (try (let loop ((r (read port)))
		      (if (eof-object? r)
			  (begin
			     (abstract-init!)
			     ;; on a fini de restorer la librairie. On 
			     ;; supprime eventuellement la fonction call/cc.
			     (if (and (not *call/cc?*)
				      (not *lib-mode*))
				 (let ((callcc (find-in-global-environment
						'call/cc *Genv*)))
				    (if (and (global? callcc)
					     (eq? (global-module callcc)
						  '__R4_CONTROL_FEATURES_6_9))
					(unbind-in-global-environment!
					 'call/cc *Genv*))))
			     (close-input-port port))
			  (let ((name (vector-ref r 1)))
			     (uncompact! r)
			     (loop (read port)))))
		   handler)))))
