;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Expand/match.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Oct  6 11:13:04 1992                          */
;*    Last change :  Wed Mar 31 09:23:05 1993  (serrano)               */
;*                                                                     */
;*    L'expansion des match-case et match-lambda                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_match
   (include "Tools/trace.sch")
   (import  match_expand
	    tools_speek)
   (export  (expand-match-case   x e)
	    (expand-match-lambda x e)))

;*---------------------------------------------------------------------*/
;*    expand-match-case ...                                            */
;*---------------------------------------------------------------------*/
(define (expand-match-case x e)
   (verbose "      (Match)" #\Newline)
   (trace eps "expand-match-case -->: " x #\Newline)
   (let ((res (do-expand-match-case x)))
      (trace eps "expand-match-case <--: " res #\Newline)
      (e res e)))

;*---------------------------------------------------------------------*/
;*    expand-match-lambda ...                                          */
;*---------------------------------------------------------------------*/
(define (expand-match-lambda x e)
   (e (do-expand-match-lambda x) e))
