;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Expand/macro.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 08:43:00 1992                          */
;*    Last change :  Mon Jul  5 15:52:15 1993  (serrano)               */
;*                                                                     */
;*    La definition de la forme `define-macro'                         */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_macro
   (export (expand-define-macro    x e)
	   (expand-define-expander x e))
   (import tools_error
	   tools_progn
	   expand_expander))
 
;*---------------------------------------------------------------------*/
;*    expand-define-expander ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-define-expander x e)
   (match-case x
      ((?- (and (not (?- . ?-)) ?name) . ?macro)
       (install-comptime-expander name (eval (normalize-progn macro)))
       `(quote ,name))
      (else
       (partial-error "define-expander" "Illegal syntax" x))))

;*---------------------------------------------------------------------*/
;*    expand-define-macro ...                                          */
;*---------------------------------------------------------------------*/
(define (expand-define-macro x e)
   (match-case x
      ((?- (?name . ?args) . ?body)
       (if (not (symbol? name))
	   (partial-error "define-macro" "not a symbol" x)
	   (begin
	      (install-comptime-expander
	       name  
	       (eval `(lambda (x e)
			 (e (let ,(destructure args '(cdr x)
					       '())
			       ,(e (normalize-progn body) e)) e))))
	      `(quote ,name))))
      (else
       (partial-error "define-macro" "Illegal syntax" x))))

;*---------------------------------------------------------------------*/
;*    destructure ...                                                  */
;*---------------------------------------------------------------------*/
(define (destructure pat arg bindings)
   (cond
      ((null? pat) bindings)
      ((symbol? pat) (cons `(,pat ,arg) bindings))
      ((pair? pat)
       (destructure (car pat) `(car ,arg)
		    (destructure (cdr pat) `(cdr ,arg)
				 bindings)))))
	   
