;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../initial.scm ...                                              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 17 18:19:23 1992                          */
;*    Last change :  Thu Apr 29 07:58:08 1993  (serrano)               */
;*                                                                     */
;*    Les expanders initiaux                                           */
;*---------------------------------------------------------------------*/
 
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_install
   (import expand_kwote
	   expand_conditional
	   expand_lambda
	   expand_define
	   expand_expander
	   expand_garithmetique
	   expand_iarithmetique
	   expand_let
	   expand_do
	   expand_case
	   expand_macro
	   expand_struct
	   expand_grammar
	   expand_try
	   expand_match
	   expand_map
	   tools_progn
	   engine_param
	   tools_error
	   var_env)
   (export (install-initial-expander)))

;*---------------------------------------------------------------------*/
;*    install-initial-expander ...                                     */
;*---------------------------------------------------------------------*/
(define (install-initial-expander)
   ;; lambda
   (install-comptime-expander 'lambda expand-lambda)
   ;; define
   (install-comptime-expander 'define expand-define)
   ;; define-inline
   (install-comptime-expander 'define-inline expand-inline)
   ;; define-struct
   (install-comptime-expander 'define-struct expand-struct)
   ;; set!
   (install-comptime-expander 'set! expand-set!)
   ;; quote
   (install-comptime-expander 'quote
			      (lambda (x e)
				 (match-case x
				    ((?- ?value)
				     (cond
					((real? value)
					 value)
					((integer? value)
					 value)
					((string? value)
					 value)
					((char? value)
					 value)
					((boolean? value)
					 value)
					(else
					 x)))
				    ((?- . (?- . ()))
				     x)
				    (else
				     (partial-error "quote"
						    "Illegal form"
						    x)))))
   ;; quasiquote
   (install-comptime-expander 'quasiquote
			      (lambda (x e)
				 (e (quasiquotation 1 x) e)))
   ;; regular-grammar
   (install-comptime-expander 'regular-grammar expand-regular-grammar)
   ;; regular-search
   (install-comptime-expander 'regular-search expand-regular-search)
   ;; append
   (install-O-comptime-expander 'append
				(lambda (x e)
				   (match-case x
				      ((?- ?l1 ?l2)
				       `(append-2 ,(e l1 e) ,(e l2 e)))
				      ((?- . ?lists)
				       `(append
					 ,@(map (lambda (l) (e l e)) lists)))
				      (else
				       (partial-error "append"
						      "Illegal form"
						      x)))))
   ;; map
   (install-O-comptime-expander 'map expand-map)
   ;; for-each
   (install-O-comptime-expander 'for-each expand-for-each)
   ;; if
   (install-comptime-expander 'if
			      (lambda (x e)
				 (match-case x
				    ((?- ?test ?alors . (?sinon . ()))
				     `(if ,(expand-test test e)
					  ,(e alors e)
					  ,(e sinon e)))
				    ((?- ?test ?alors)
				     `(if ,(expand-test test e)
					  ,(e alors e)
					  #f))
				    (else
				     (partial-error "if" "Illegal form" x)))))
   ;; bind-exit
   (install-comptime-expander 'bind-exit
			      (lambda (x e)
				 (match-case x
				    ((?- (?escape) . ?body)
				     `(bind-exit (,escape)
						 ,(e (normalize-progn body)
						     e)))
				    (else
				     (partial-error "bind-exit"
						    "Illegal form"
						    x)))))
   ;; begin
   (install-comptime-expander 'begin 
			      (lambda (x e)
				 (match-case x
				    ((?- . ?body)
				     `(begin ,@(map (lambda (x) (e x e))
						    body)))
				    (else
				     (partial-error "begin"
						    "Illegal form"
						    x)))))
   ;; cond
   (install-comptime-expander 'cond (lambda (x e)
				       (e (expand-cond x) e)))
   ;; or
   (install-comptime-expander 'or (lambda (x e)
				     (e (expand-or x) e)))
   ;; and
   (install-comptime-expander 'and (lambda (x e)
				      (e (expand-and x) e)))
   ;; les procedures arithmetiques
   (if *genericity*
       (begin
	  ;; +
	  (install-O-comptime-expander '+ expand-g+)
	  ;; *
	  (install-O-comptime-expander '* expand-g*)
	  ;; /
	  (install-O-comptime-expander '/ expand-g/)
	  ;; -
	  (install-O-comptime-expander '- expand-g-)
	  ;; =
	  (install-O-comptime-expander '= expand-g=)
	  ;; <
	  (install-O-comptime-expander '< expand-g<)
	  ;; >
	  (install-O-comptime-expander '> expand-g>)
	  ;; <=
	  (install-O-comptime-expander '<= expand-g<=)
	  ;; >=
	  (install-O-comptime-expander '>= expand-g>=))
       (begin
	  ;; +
	  (install-O-comptime-expander '+ expand-i+)
	  ;; *
	  (install-O-comptime-expander '* expand-i*)
	  ;; /
	  (install-O-comptime-expander '/ expand-i/)
	  ;; -
	  (install-O-comptime-expander '- expand-i-)
	  ;; =
	  (install-O-comptime-expander '= expand-i=)
	  ;; <
	  (install-O-comptime-expander '< expand-i<)
	  ;; >
	  (install-O-comptime-expander '> expand-i>)
	  ;; <=
	  (install-O-comptime-expander '<= expand-i<=)
	  ;; >=
	  (install-O-comptime-expander '>= expand-i>=)))
   ;; +fx
   (install-O-comptime-expander '+fx expand-+fx)
   ;; -fx
   (install-O-comptime-expander '-fx expand--fx)
   ;; let*
   (install-comptime-expander 'let* expand-let*)
   ;; let
   (install-comptime-expander 'let expand-let)
   ;; letrec
   (install-comptime-expander 'letrec expand-letrec)
   ;; do
   (install-comptime-expander 'do expand-do)
   ;; labels
   (install-comptime-expander 'labels expand-labels)
   ;; case
   (install-comptime-expander 'case expand-case)
   ;; delay
   (install-comptime-expander 'delay
			      (lambda (x e)
				 (match-case x
				    ((?- ?exp)
				     `(make-promise (lambda () ,(e exp e))))
				    (else
				     (partial-error "delay"
						    "Illegal form"
						    x)))))
   ;; read
   (install-O-comptime-expander 'read
				(lambda (x e)
				   (match-case x
				      ((?- ?port)
				       `(read ,(e port e)))
				      ((?-)
				       `(read (current-input-port)))
				      (else
				       (partial-error "read"
						      "Illegal form"
						      x)))))
   ;; read/rp
   (install-O-comptime-expander 'read/rp
				(lambda (x e)
				   (match-case x
				      ((?- ?grammar ?port)
				       (if *unsafe-type*
					   `(read/rp-ut ,(e grammar e)
							,(e port e))
					   `(read/rp ,(e grammar e)
						     ,(e port e))))
				      (else
				       (partial-error "read/rp"
						      "Illegal form"
						      x)))))
   ;; vector-set!
   (install-O-comptime-expander 'vector-set!
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k ?obj)
				       (let ((evec (e vec e))
					     (ek   (e k e))
					     (eobj (e obj e)))
					  (if *unsafe-range*
					      `(vector-set-ur! ,evec ,ek ,eobj)
					      `(vector-set! ,evec ,ek ,eobj))))
				      (else
				       (partial-error "vector-set!"
						      "Illegal form"
						      x)))))
   ;; vector-ref
   (install-O-comptime-expander 'vector-ref
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k)
				       (let ((evec (e vec e))
					     (ek   (e k e)))
					  (if *unsafe-range*
					      `(vector-ref-ur ,evec ,ek)
					      `(vector-ref ,evec ,ek))))
				      (else
				       (partial-error "vector-ref"
						      "Illegal form"
						      x)))))
   ;; string-set!
   (install-O-comptime-expander 'string-set!
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k ?obj)
				       (let ((evec (e vec e))
					     (ek   (e k e))
					     (eobj (e obj e)))
					  (if *unsafe-range*
					      `(string-set-ur! ,evec ,ek ,eobj)
					      `(string-set! ,evec ,ek ,eobj))))
				      (else
				       (partial-error "string-set!"
						      "Illegal form"
						      x)))))
   ;; string-ref
   (install-O-comptime-expander 'string-ref
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k)
				       (let ((evec (e vec e))
					     (ek   (e k e)))
					  (if *unsafe-range*
					      `(string-ref-ur ,evec ,ek)
					      `(string-ref ,evec ,ek))))
				      (else
				       (partial-error "string-ref"
						      "Illegal form"
						      x)))))
   ;; integer->char
   (install-O-comptime-expander 'integer->char
				(lambda (x e)
				   (match-case x
				      ((?- ?n)
				       (if *unsafe-range*
					   `(integer->char-ur ,(e n e))
					   `(integer->char ,(e n e)))))))
   ;; define-comptime-expander
   (install-comptime-expander 'define-expander expand-define-expander)
   ;; define-macro
   (install-comptime-expander 'define-macro expand-define-macro)
   ;; failure
   (install-comptime-expander 'failure
			      (lambda (x e)
				 (match-case x
				    ((?- ?proc ?msg ?obj)
				     `(failure ,(e proc e)
					       ,(e msg e)
					       ,(e obj e)))
				    (else
				     (partial-error "failure"
						    "Illegal form"
						    x)))))
   ;; try
   (install-comptime-expander 'try expand-try)
   ;; match-case
   (install-comptime-expander 'match-case expand-match-case)
   ;; match-lambda
   (install-comptime-expander 'match-lambda expand-match-lambda)
   ;; apply
   (install-O-comptime-expander 'apply
				(lambda (x e)
				   (match-case x
				      ((?- ?function ?one-arg)
				       `(apply ,(e function e)
					       ,(e one-arg e)))
				      ((?- ?function . ?args)
				       `(apply ,(e function e)
					       ,(e `(cons* ,@args) e)))
				      (else
				       (partial-error "apply"
						      "Illegal form"
						      x))))))
   
			 
					
 
