;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*    .../define.scm ...                                               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 18 14:05:29 1992                          */
;*    Last change :  Tue May 11 15:09:26 1993  (serrano)               */
;*                                                                     */
;*    L'expansion des formes define                                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_define
   (include "Var/variable.sch"
	    "Expand/expander.sch"
	    "Tools/trace.sch")
   (import  tools_progn
	    tools_args
	    tools_error
	    tools_speek
	    expand_eps
	    expand_lambda
	    engine_param
	    var_env)
   (export  (expand-define x e)
	    (expand-inline x e)
	    (expand-set!   x e)))

;*---------------------------------------------------------------------*/
;*    expand-define ...                                                */
;*    -------------------------------------------------------------    */
;*    on divise en deux sous:                                          */
;*       1- on define une lambda.                                      */
;*       2- on define une valeur (autre qu'un lambda).                 */
;*---------------------------------------------------------------------*/
(define (expand-define x e)
   (trace eps "expand-define: " x
	  " " (if internal-definition? "[internal]" "[external]")
	  #\Newline)
   (if internal-definition?
       (expand-internal-define x e)
       (expand-external-define x e)))

;*---------------------------------------------------------------------*/
;*    expand-external-define ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-external-define x e)
   (set! internal-definition? #t)
   (let ((res (match-case x
		 ;; 1- on definit une lambda 
		 ((or (?- (?name . ?args) . ?body)
		      (?- ?name (lambda ?args . ?body)))
		  (do-external-define-lambda e name args body))
		 ;; 3- on definit une valeur non typee
		 ((?- ?name . (?value . ()))
		  (do-external-define-value e name value))
		 ;; 3b- on definit une valeur typee
		 (else
		  (partial-error "define" "Illegal form" x)))))
      (set! internal-definition? #f)
      res))

;*---------------------------------------------------------------------*/
;*    expand-internal-define ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-internal-define x e)
   (let ((e (internal-begin-expander e)))
      (match-case x
	 ;; 1- on definit une lambda typee
	 ((?- ((?type ?name) . ?args) . ?body)
	  (with-lexical
	   (args*->args-list args)
	   (lambda ()
	      `(define (,type ,name)
		  (lambda ,args ,(e (force-progn body) e))))))
	 ;; 1- on definit une lambda non typee
	 ((or (?- (?name . ?args) . ?body)
	      (?- ?name (lambda ?args . ?body)))
	  (with-lexical
	   (args*->args-list args)
	   (lambda ()
	      `(define ,name
		  (lambda ,args ,(e (force-progn body) e))))))
	 ;; 2- on definit une valeur non typee
	 ((?- ?name . (?value . ()))
	  `(define ,name ,(e value e)))
	 ;; 2b- on definit une valeur typee
	 (else
	  (partial-error "define" "Illegal form" x)))))

;*---------------------------------------------------------------------*/
;*    expand-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-set! x e)
   (match-case x
      ((?- ?var . (?value . ()))
       ;; on test si la variable est liee quelque part
       (enter-function var)
       (let ((ev (e value e)))
	  (leave-function)
	  `(set! ,var ,ev)))
      (else
       (partial-error "set!" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    expand-inline ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-inline x e)
   (match-case x
	 ((?- (?name . ?args) . ?body)
	  (with-lexical
	   (args*->args-list args)
	   (lambda ()
	      (do-inline e name args body))))
	 (else
	  (partial-error "define-inline" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    do-external-define-lambda ...                                    */
;*---------------------------------------------------------------------*/
(define (do-external-define-lambda e name args body)
   (enter-function name)
   (let* ((symbol (if (symbol? name)
		      name
		      (string->symbol name)))
	  (O-exp  (find-in-global-environment symbol *Oenv*))
	  (e      (internal-begin-expander e)))
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "top-level" "Redefinition of library function -- " name)
	     (unbind-in-global-environment! symbol *Oenv*)))
      (let ((ebody  (with-lexical
		     (args*->args-list args)
		     (lambda ()
			(e (if *debug*
			       `(begin
				   (push-lambda-trace ',symbol)
				   (pop-lambda-trace ,(force-progn body)))
			       (force-progn body))
			   e)))))
	 (leave-function)
	 `(define ,(cons name args) ,ebody))))

;*---------------------------------------------------------------------*/
;*    do-external-define-value ...                                     */
;*---------------------------------------------------------------------*/
(define (do-external-define-value e name value)
   (let* ((symbol (if (symbol? name)
		      name
		      (string->symbol name)))
	  (O-exp  (find-in-global-environment symbol *Oenv*))
	  (e      (internal-begin-expander e)))
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "Redefinition of library function -- " name)
	     (unbind-in-global-environment! symbol *Oenv*)))
      (let ((evalue (e value e)))
	 `(define ,name ,evalue))))

;*---------------------------------------------------------------------*/
;*    do-inline ...                                                    */
;*---------------------------------------------------------------------*/
(define (do-inline e name args body)
   (enter-function name)
   (let* ((symbol (if (symbol? name)
		      name
		      (string->symbol name)))
	  (O-exp  (find-in-global-environment name *Oenv*))
	  (e      (internal-begin-expander e))
	  (body   (with-lexical
		   (args*->args-list args)
		   (lambda ()
		      (e (if *extra-debug*
			     `(begin
				 (push-lambda-trace ',name)
				 (pop-lambda-trace ,(force-progn body)))
			     (force-progn body))
			 e)))))
      (leave-function)
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (global? O-exp) (not *lib-mode*))
	  (begin
	     (warning "Redefinition of library function -- " name)
	     (unbind-in-global-environment! name *Oenv*)))
      `(define-inline ,(cons name args) ,body)))

