;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.3/Engine/param.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 09:59:39 1993                          */
;*    Last change :  Mon Jun 21 09:58:27 1993  (serrano)               */
;*                                                                     */
;*    Les variables qui indiquent ce que doit faire bigloo.            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_param
   (import  tools_module
	    (tools_date "Tools/date.scm") ;; ce fichier est genere.
	    engine_path)                  ;; il ne peut pas etre dans le
   (export  *bigloo-name*                 ;; .afile
	    *bigloo-cmd-name*  
	    *bigloo-args*      
	    *bigloo-author*    
	    *bigloo-email*     
	    *bigloo-date*      
	    *lib-mode*         
	    *silent*           
	    *verbose*          
	    *warning*          
	    *unsafe-type*      
	    *unsafe-range*     
	    *unsafe-struct*    
	    *unsafe-arity*     
	    *optim*
	    *optim-rgc*
	    *inlining?*
	    *genericity*
	    *shared-data*
	    *alpha*            
	    *nil*              
	    *debug*            
	    *extra-debug*      
	    *c-debug*          
	    *c-debug-option*   
	    *error-shape*   
	    *pp-env-mode*      
	    *src*              
	    *tmp-dest*         
	    *dest*
	    *cc*               
	    *ansi-cc*               
	    *cc-options*       
	    *gcc*
	    *rm-c-files*       
	    *ld-options*       
	    *strip*            
	    *bigloo-lib*       
	    *lib-dir*          
	    *include-dir*      
	    *include-foreign*  
	    *indent*           
	    *access-file*      
	    *access-table*     
	    *o-files*          
	    *with-files*
	    *order-init-modules*
	    *init-functions*   
	    *interpreter*      
	    *startup-file*     
	    *eval?*            
	    *call/cc?*         
	    *pass*             
	    *in-style*         
	    *out-style*        
	    *last-char*        
	    *first-char*       
	    *rgc-compact*
	    *inline-level-max*
	    *separateur*       
	    *heap-name*        
	    *main*             
	    *module-name*
	    (initialisation-name)))
	     
;*---------------------------------------------------------------------*/
;*    Les auteurs et le nom du soft                                    */
;*---------------------------------------------------------------------*/
(define *bigloo-name*       "Bigloo (v1.3)")
(define *bigloo-cmd-name*   'nothing-yet)
(define *bigloo-args*       'nothing-yet)
(define *bigloo-author*     "Manuel Serrano")
(define *bigloo-email*      "Manuel.Serrano@inria.fr")
(define *bigloo-date*       (bigloo-date))

;*---------------------------------------------------------------------*/
;*    Le bavardage ...                                                 */
;*---------------------------------------------------------------------*/
(define *silent*            #f)        ;; veut-on etre tres silencieux ?
(define *verbose*           #f)        ;; veut-on etre tres bavard ?
(define *warning*           #t)        ;; Et les warning ?
(define *pp-env-mode*       'short)    ;; On trace en petit, par defaut

;*---------------------------------------------------------------------*/
;*    Les noms des differents fichiers                                 */
;*---------------------------------------------------------------------*/
(define *src*               #f)        ;; Le #t par default signifie que
(define *tmp-dest*          #f)        ;; si l'utilisateur ne precise pas
(define *dest*              #f)        ;; de fichier on lira sur la console.

;*---------------------------------------------------------------------*/
;*    Les versions de ce qu'on lit et de ce qu'on ecrit                */
;*---------------------------------------------------------------------*/
(define *in-style*          10)
(define *out-style*         10)
(define *separateur*        "@")

;*---------------------------------------------------------------------*/
;*    Les variables de Rgc                                             */
;*---------------------------------------------------------------------*/
(define *last-char*         255)
(define *first-char*        1)
(define *rgc-compact*       50)
(define *optim-rgc*         #f)

;*---------------------------------------------------------------------*/
;*    La profondeur maximum des inlines                                */
;*---------------------------------------------------------------------*/
(define *inline-level-max*  4)

;*---------------------------------------------------------------------*/
;*    Le compilateur C et ses options                                  */
;*---------------------------------------------------------------------*/
(define *cc*                "gcc")
(define *ansi-cc*           #t)
(define *cc-options*        "")
(define *gcc*               #f)
(define *rm-c-files*        #t)
(define *ld-options*        "")
(define *strip*             #f)
(define *bigloo-lib*        "bigloo")
(define *lib-dir*           (get-lib-dir))
(define *include-dir*       (get-inc-dir))
(define *include-foreign*   `("bigloo.h"))
(define *heap-name*         (string-append (get-lib-dir) "/bigloo.heap"))
(define *indent*            "indent")
(define *c-debug*           #f)
(define *c-debug-option*    "-g")

;*---------------------------------------------------------------------*/
;*    Les fichier de link                                              */
;*---------------------------------------------------------------------*/
(define *access-file*        #f)    ;; fichier d'indirection
(define *access-table*       '())   ;; la table d'indirection
(define *o-files*            "")    ;; avec quels fichiers link-t-on ?
(define *with-files*         "")    ;; les modules pour faire l'application
(define *imported-modules*   '())   ;; la liste des modules a importer
(define *order-init-modules* '())   ;; l'ordre d'initialisation des modules
(define *init-functions*     '())   ;; la liste des fonctions d'initialisation
   
;*---------------------------------------------------------------------*/
;*    Les differentes pass de la compilation                           */
;*---------------------------------------------------------------------*/
(define *interpreter*       #f)     ;; compile-t-on ou interprete-t-on ?
(define *startup-file*      #f)     ;; le fichier `rc' de l'interprete
(define *eval?*             #f)
(define *call/cc?*          #f)
(define *pass*             'ld)

;*---------------------------------------------------------------------*/
;*    Les modes de compilations                                        */
;*---------------------------------------------------------------------*/
(define *unsafe-type*       #f)
(define *unsafe-arity*      #f)
(define *unsafe-range*      #f)
(define *unsafe-struct*     #f)
(define *debug*             #f)
(define *extra-debug*       #f)
(define *error-shape*       #f)
(define *alpha*             #t)
(define *nil*               #t)
(define *optim*             0)
(define *inlining?*         #t)
(define *genericity*        #t)
(define *shared-data*       #f)
(define *lib-mode*          #f)

;*---------------------------------------------------------------------*/
;*    Le nom du module qu'on est en train de compiler                  */
;*---------------------------------------------------------------------*/
(define *module-name*       #f)

;*---------------------------------------------------------------------*/
;*    Le point d'entree de la compilation                              */
;*---------------------------------------------------------------------*/
(define *main*              #f)

;*---------------------------------------------------------------------*/
;*    initialisation-name ...                                          */
;*---------------------------------------------------------------------*/
(define (initialisation-name)
   (module-init-name *module-name*))
