;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../engine.scm ...                                               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:13:23 1993                          */
;*    Last change :  Wed Mar 17 14:36:42 1993  (serrano)               */
;*                                                                     */
;*    Voila, on a lu les parametres d'appel. On Commence vraiment      */
;*    le travail de compilation ou d'interpretation                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_engine
   (export (bigloo)
	   (hello-world))
   (import tools_speek
	   write_version
           engine_param
	   engine_compiler
	   engine_interp))

;*---------------------------------------------------------------------*/
;*    bigloo ...                                                       */
;*---------------------------------------------------------------------*/
(define (bigloo)
   (if (or *interpreter* (not *src*))
       (interp version
	       *silent*
	       *src*
	       *startup-file*
	       (string-append *lib-dir* "/scheme-files")
	       *bigloo-cmd-name*
	       *bigloo-args*)
       (compiler)))

;*---------------------------------------------------------------------*/
;*    hello-world ...                                                  */
;*---------------------------------------------------------------------*/
(define (hello-world)
   ;; aller, on dit bonjour
   (say (string-append *src* ":") #\Newline))




	   


