;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../compiler.scm ...                                             */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 10:17:08 1993                          */
;*    Last change :  Thu May  6 16:57:41 1993  (serrano)               */
;*                                                                     */
;*    On compile vraiment un fichier                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module engine_compiler
   (export (compiler))
   (import engine_param
	   write_expanded
	   write_tree
	   read_access
	   read_src
	   var_env
	   expand_install
	   expand_eps
	   heap_make
	   scan_walk
	   inline_walk
	   type_walk
	   0cfa_walk
	   hoist_walk
	   effect_walk
	   cse_walk
	   beta_walk
	   lift_walk
	   cnst_walk
	   integ_walk
	   cgen_walk
	   cc_cc
	   cc_indent
	   cc_ld))
	   
;*---------------------------------------------------------------------*/
;*    stop-on-pass ...                                                 */
;*---------------------------------------------------------------------*/
(define (stop-on-pass pass thunk)
   (if (eq? *pass* pass)
       (begin
	  (thunk)
	  (exit 0))))

;*---------------------------------------------------------------------*/
;*    compiler ...                                                     */
;*---------------------------------------------------------------------*/
(define (compiler)
   ;; on commence par lire le fichier d'access
   (read-access-file)
   ;; On creer la table de hash pour les macros et les globales
   (init-global-environment!)
   ;; on installe les macros initiales
   (install-initial-expander)
   (let ((code (read-src)))
      ;; on fait la macro-expansion du code.
      (set! code (expand-code code))
      (stop-on-pass 'expand (lambda () (write-expanded code)))
      ;; on scan le code pour trouver les definitions manquantes,
      ;; verifier les autres et construire l'arbre de syntaxe abstraite.
      (let ((tree (scan-walk code)))
	 ;; on sauve le tas
	 (stop-on-pass 'make-heap (lambda () (make-heap)))
	 ;; on inline le code
	 (set! tree (inline-walk tree))
	 (stop-on-pass 'inline (lambda () (write-tree tree)))
	 ;; on pose les tests de type et les fonctions de conversions
	 (set! tree (type-walk tree))
	 (stop-on-pass 'type (lambda () (write-tree tree)))
	 ;; on fait l'analyse de control (en mode -O2)
	 (if (>fx *optim* 1)
	     (begin
		(set! tree (0cfa tree))
		(stop-on-pass '0cfa (lambda () (write-tree tree)))))
	 ;; on fait la failure-hoisting
	 (set! tree (hoist-walk tree))
	 (stop-on-pass 'hoist (lambda () (write-tree tree)))
	 ;; on elimine les expressions communes et
	 ;; on fait de la beta-reductions
	 (if (>fx *optim* 0)
	     (begin
		(if (>fx *optim* 1)
		    (effect-walk tree))
		(set! tree (cse-walk tree))
		(stop-on-pass 'cse (lambda () (write-tree tree)))
		(set! tree (beta-walk tree))
		(stop-on-pass 'beta (lambda () (write-tree tree)))))
	 ;; on fait le lambda-lifting
	 (set! tree (lift-walk tree))
	 (stop-on-pass 'lift (lambda () (write-tree tree)))
	 ;; on alloue les constantes
	 (set! tree (cnst-walk tree))
	 (stop-on-pass 'cnst (lambda () (write-tree tree)))
	 ;; on fait l'integration pour C
	 (if (not *gcc*)
	     (begin
		(set! tree (integ-walk tree))
		(stop-on-pass 'integ (lambda () (write-tree tree)))))
		;; on genere le code C
	 (let ((c-preffix (cgen-walk tree)))
	    (stop-on-pass 'cgen (lambda () 'done))
	    (stop-on-pass 'distrib (lambda () 'done))
	    ;; on indent (eventuellement)
	    (if (or (eq? *pass* 'cindent) *c-debug*)
		(indent c-preffix))
	    (stop-on-pass 'cindent (lambda () 'done))
	    ;; on compile
	    (cc c-preffix)
	    (stop-on-pass 'cc (lambda () 'done))
	    ;; on link
	    (ld c-preffix)
	    'done))))
		       
		 
	       
	       

      

	  
	  
