;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.2/Effect/fix.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 30 15:30:41 1993                          */
;*    Last change :  Fri Apr 30 15:58:05 1993  (serrano)               */
;*                                                                     */
;*    On fait une iteration de point fixe jusqu'a trouver toutes       */
;*    les fonctions qui font des effets de bords.                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module effect_fix
   (include "Var/variable.sch"
	    "Effect/temp.sch"
	    "Effect/effect.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    var_pragma
	    effect_cgraph)
   (export (iterate-to-fixpoint W)))

;*---------------------------------------------------------------------*/
;*    iterate-to-fixpoint ...                                          */
;*---------------------------------------------------------------------*/
(define (iterate-to-fixpoint W)
   (trace effect "W: " (shape W) #\Newline)
   (let loop ((W W))
      (if (null? W)
	  (begin
	     ;; il ne reste plus qu'a marquer pour toutes les fonctions
	     ;; qu'elles sont celles qui font des effets de bords.
	     (mark-all-functions! (get-all-functions)))
	  (loop (mark-new-side-effect! W)))))

;*---------------------------------------------------------------------*/
;*    mark-all-functions! ...                                          */
;*---------------------------------------------------------------------*/
(define (mark-all-functions! funs)
   (for-each (lambda (f)
		(let (info value)
		   (if (local? f)
		       (begin
			  (set! info (local-info f))
			  (set! value (local-value f)))
		       (begin
			  (set! info (global-info f))
			  (set! value (global-value f))))
		   (trace effect "--> " (shape f) "  : " (temp-seter info)
			  #\Newline)
		   (if (not (temp-seter info))
		       (get-effect! value))))
	     funs))

;*---------------------------------------------------------------------*/
;*    get-effect! ...                                                  */
;*---------------------------------------------------------------------*/
(define (get-effect! value)
   (if (effect? (function-property value))
       (function-property value)
       (let ((effect (make-effect)))
	  (effect-seter-set! effect #f)
	  (function-property-set! value effect)
	  effect)))

;*---------------------------------------------------------------------*/
;*    mark-new-side-effect! ...                                        */
;*---------------------------------------------------------------------*/
(define (mark-new-side-effect! W)
   ;; on dit que tous les appellants font des effets de bords et
   ;; on boucle sur les nouvelles fonctions.
   (let loop ((old-W W)
	      (new-W '()))
      (if (null? old-W)
	  new-W
	  (let ((w (car old-W)))
	     (let laap ((cfrom (temp-cfrom (get-info w)))
			(new-W new-W))
		(if (null? cfrom)
		    (loop (cdr old-W)
			  new-W)
		    (if (temp-seter (get-info (car cfrom)))
			(laap (cdr cfrom)
			      new-W)
			(begin
			   (temp-seter-set! (get-info (car cfrom)) #t)
			   (laap (cdr cfrom)
				 (cons (car cfrom) new-W))))))))))
	      

   
