;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Cse/cse.scm ...          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 28 11:58:04 1993                          */
;*    Last change :  Sun Apr 25 10:15:02 1993  (serrano)               */
;*                                                                     */
;*    On les elimines maintenant                                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cse_cse
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    type_type
	    type_enforce
	    heap_abstract
	    var_pragma)
   (export  (cse exp stack-local stack-test)))

;*---------------------------------------------------------------------*/
;*    cse ...                                                          */
;*    -------------------------------------------------------------    */
;*    On collect des informations a deux endroits:                     */
;*       - dans les liaisons des `let'                                 */
;*       - dans les `si' des `if'                                      */
;*---------------------------------------------------------------------*/
(define (cse exp stack-local stack-test)
   (trace remove "remove: " (shape exp) #\Newline
	          "    sl: " (shape stack-local) #\Newline
		  "    st: " (shape stack-test) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (trace remove "atom: " (shape exp) #\Newline)
       (if (and (local? exp)
		(not (null? (local-info exp))))
	   (local-info exp)
	   exp))
;*--- function --------------------------------------------------------*/
      ((function ?-)
       (set-car! (cdr exp) (cse (cadr exp)
				      stack-local
				      stack-test))
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (set-car! (cdr exp) (cse (cadr exp) stack-local stack-test))
       (set-car! (cddr exp) (cse (caddr exp) stack-local stack-test))
       (set-car! (cdddr exp) (cse (cadddr exp) stack-local stack-test))
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (set-car! (cdr exp) (cse (cadr exp) stack-local stack-test))
       (let ((tv (test-value (cadr exp) stack-test)))
	  (cond
	     ((null? tv)
	      (trace remove "no-side-effect (" (shape (cadr exp)) ") --> "
		     (no-side-effect? (cadr exp)) #\Newline)
	      (if (no-side-effect? (cadr exp))
		  (begin
		     (set-car! (cddr exp)
			       (cse (caddr exp)
					  stack-local
					  (cons (cons (cadr exp) #t)
						stack-test)))
		     (set-car! (cdddr exp)
			       (cse (cadddr exp)
					  stack-local
					  (cons (cons (cadr exp) #f)
						stack-test))))
		  (begin
		     (set-car! (cddr exp)
			       (cse (caddr exp)
					  stack-local
					  stack-test))
		     (set-car! (cdddr exp)
			       (cse (cadddr exp)
					  stack-local
					  stack-test))))
	      exp)
	     (tv
	      (cse (caddr exp) stack-local stack-test))
	     (else
	      (cse (cadddr exp) stack-local stack-test)))))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (cse test stack-local stack-test))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdar hook)
			   (cse (cadr (car hook))
				      stack-local
				      stack-test))
		 (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cse (car hook)
					   stack-local
					   stack-test))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (set-car! (cddr exp) (cse (caddr exp) stack-local stack-test))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (cse-let exp stack-local stack-test))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (for-each (lambda (b)
		    (local-info-set! (car b) '())
		    (for-each (lambda (f)
				 (local-info-set! f '()))
			      (cadr b)))
		 bindings)
       (set-car! (cddr exp) (cse (caddr exp) stack-local stack-test))
       (let loop ((hook bindings))
	  (if (null? hook)
	      exp
	      (let ((binding (car hook)))
		 (set-car! (cddr binding) (cse (caddr binding)
						     stack-local
						     stack-test))
		 (loop (cdr hook))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (set-car! (cddr exp) (cse (caddr exp) stack-local stack-test))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (set-car! (cddr exp) (cse (caddr exp) stack-local stack-test))
       exp)
;*--- apply -----------------------------------------------------------*/
      (((and ?op (or apply funcall)) . ?-)
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cse (car hook) stack-local stack-test))
		 (loop (cdr hook))))))
;*--- application -----------------------------------------------------*/
      (else
       (let loop ((hook exp))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cse (car hook) stack-local stack-test))
		 (loop (cdr hook))))))))

;*---------------------------------------------------------------------*/
;*      cse-let ...                                                    */
;*    -------------------------------------------------------------    */
;*    Il faut absolument que le corps du `let' soit parcouru apres     */
;*    qu'on ai fait tous les traitements sur les liaisons (pour la     */
;*    beta-reduction).                                                 */
;*---------------------------------------------------------------------*/
(define (cse-let exp stack-local stack-test)
   (let loop ((bindings        (cadr exp))
	      (tail            '())
	      (new-stack-local stack-local)
	      (new-stack-test  stack-test))
      (cond
	 ((null? bindings)
	  (if (null? tail)
	      (cse (caddr exp) new-stack-local new-stack-test)
	      (begin
		 (set-car! (cddr exp) (cse (caddr exp)
						 new-stack-local
						 new-stack-test))
		 exp)))
	 (else
	  (let* ((binding (car bindings))
		 (var     (car binding))
		 (val     (cadr binding)))
	     (local-info-set! var '())
	     (set-car! (cdr binding)
		       (cse val stack-local new-stack-test))
	     (cond
		((eq? (local-access var) 'write)
		 ;; la variable est affecte dans le let, on ne fait donc
		 ;; aucune optimisation dessus.
		 (loop (cdr bindings)
		       bindings
		       new-stack-local
		       new-stack-test))
		((local? (cadr binding))
		 ;; c'est une liaison qui porte sur deux variables.
		 (if (eq? (local-access (cadr binding)) 'write)
		     (loop (cdr bindings)
			   bindings
			   new-stack-local
			   new-stack-test)  
		     (begin
			(local-info-set! var (cadr binding))
			;; on coupe la branche de la liaison
			(cond
			   ((null? tail)
			    (if (null? (cdr bindings))
				;; aucune liaison ne reste
				(loop '()
				      '()
				      new-stack-local
				      new-stack-test)
				(begin
				   (set-car! (cdr exp) (cdr (cadr exp)))
				   (loop (cdr bindings)
					 '()
					 new-stack-local
					 new-stack-test))))
			   (else
			    (set-cdr! tail (cdr bindings))
			    (loop (cdr bindings)
				  tail
				  new-stack-local
				  new-stack-test))))))
		(else
		 (if (no-side-effect? (cadr binding))
		     (let ((ce (assoc (cadr binding) stack-local)))
			(if (pair? ce)
			    ;; on a deja calcule cette expression
			    (begin
			       ;; on marque l'expression commune.
			       (local-info-set! var (cdr ce))
			       ;; on coupe la branche de la liaison
			       (cond
				  ((null? tail)
				   (if (null? (cdr bindings))
				       ;; aucune liaison ne reste
				       (loop '()
					     '()
					     new-stack-local
					     new-stack-test)
				       (begin
					  (set-car! (cdr exp) (cdr (cadr exp)))
					  (loop (cdr bindings)
						'()
						new-stack-local
						new-stack-test))))
				  (else
				   (set-cdr! tail (cdr bindings))
				   (loop (cdr bindings)
					 tail
					 new-stack-local
					 new-stack-test))))
			    ;; on n'a jamais calcule cette expression
			    (let ((new-stack-test
				   (case (type-of (cadr binding))
				      ((bint)
				       (cons (cons
					      (abstract-integer? (car binding))
					      #t)
					     new-stack-test))
				      ((breal)
				       (cons (cons
					      (abstract-real? (car binding))
					      #t)
					     new-stack-test))
				      ((bpair)
				       (cons (cons
					      (abstract-pair? (car binding))
					      #t)
					     new-stack-test))
				      ((bchar)
				       (cons (cons
					      (abstract-char? (car binding))
					      #t)
					     new-stack-test))
				      ((bstring)
				       (cons (cons
					      (abstract-string? (car binding))
					      #t)
					     new-stack-test))
				      ((bvector)
				       (cons (cons
					      (abstract-vector? (car binding))
					      #t)
					     new-stack-test))
				      (else
				       new-stack-test))))
			       (loop (cdr bindings)
				     bindings
				     (cons (cons (cadr binding)
						 var)
					   stack-local)
				     new-stack-test))))
		     (loop (cdr bindings)
			   bindings
			   new-stack-local
			   new-stack-test)))))))))
			      
;*---------------------------------------------------------------------*/
;*    no-side-effect? ...                                              */
;*    -------------------------------------------------------------    */
;*    Y-a-t-il des effets de bords dans une expression. Cette fonction */
;*    realise une approximation tres grossiere mais aussi tres         */
;*    conservative...                                                  */
;*---------------------------------------------------------------------*/
(define (no-side-effect? exp)
   (cond
      ((not (pair? exp))
       (cond
	  ((local? exp)
	   (not (eq? (local-access exp) 'write)))
	  ((global? exp)
	   #t)
	  (else
	   #t)))
      ((local? (car exp))
       #f)
      ((global? (car exp))
       (pragma-no-side-effect? (car exp)))
      (else
       #f)))
	 
;*---------------------------------------------------------------------*/
;*    test-value ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-value exp stack)
   (let ((cell (assoc exp stack)))
      (if (pair? cell)
	  (cdr cell)
	  '())))

