;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Cnst/init.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 18:38:46 1993                          */
;*    Last change :  Tue Apr 27 19:42:14 1993  (serrano)               */
;*                                                                     */
;*    Le trippotage de la fonction d'initialisation                    */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_init
   (include "Var/variable.sch")
   (import  var_env
	    var_declare
	    cnst_alloc
	    cnst_module
	    heap_abstract
	    engine_param)
   (export  (cnst-init-module! form)))

;*---------------------------------------------------------------------*/
;*    cnst-init-module! ...                                            */
;*    -------------------------------------------------------------    */
;*    Il faut rajouter dans la fonction d'initialisation du module     */
;*    toutes les pre-allocations.                                      */
;*---------------------------------------------------------------------*/
(define (cnst-init-module! var)
   (let* ((old-body     (function-body (global-value var)))
	  (module       (modules-initialisation))
	  (string       (string-initialisation))
	  (symbol       (symbol-initialisation))
	  (pair         (pair-initialisation))
	  (procedure    (procedure-initialisation))
	  (require      (declare-global-variable! 'require-initialisation?
						  *module-name*
						  'static))
	  (new-body     `(cif ,(abstract-bbool->cbool require)
			      (begin
				 (set! ,require ,(abstract-false))
				 ,@(append module
					   string
					   symbol
					   pair
					   procedure)
				 ,old-body)
			      ,(abstract-unspecified))))
      (function-body-set! (global-value var) new-body)))
