;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expression.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 14:18:09 1993                          */
;*    Last change :  Mon Jun 21 16:23:27 1993  (serrano)               */
;*                                                                     */
;*    L'allocation des constantes                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_expression
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  heap_abstract
	    engine_param
	    cnst_alloc
	    cnst_module
	    tools_shape)
   (export  (cnst exp)))

;*---------------------------------------------------------------------*/
;*    cnst ...                                                         */
;*---------------------------------------------------------------------*/
(define (cnst exp)
   (let loop ((exp exp))
      (trace cnst "exp: " (shape exp) #\Newline)
      (match-case exp
;*--- nil -------------------------------------------------------------*/
	 (()
	  exp)
;*--- atom ------------------------------------------------------------*/
	 ((atom ?-)
	  (if (global? exp)
	      (if (not (eq? (global-class exp) 'foreign))
		  (remember-module! (global-module exp))))
	  exp)
;*--- set! ------------------------------------------------------------*/
	 ((set! . ?-)
	  (set-car! (cddr exp) (cnst (caddr exp)))
	  exp)
;*--- function --------------------------------------------------------*/
	 ((function ?var)
	  exp)
;*--- quote -----------------------------------------------------------*/
	 ((quote ?-)
	  (cnst-quote (cadr exp)))
;*--- failure ---------------------------------------------------------*/
	 ((failure . ?-)
	  (set-car! (cdr exp) (cnst (cadr exp)))
	  (set-car! (cddr exp) (cnst (caddr exp)))
	  (set-car! (cdddr exp) (cnst (cadddr exp)))
	  exp)
;*--- cif -------------------------------------------------------------*/
	 ((cif . ?-)
	  (set-car! (cdr exp) (cnst (cadr exp)))
	  (if (boolean? (cadr exp))
	      (if (cadr exp)
		  (cnst (caddr exp))
		  (cnst (cadddr exp)))
	      (begin
		 (set-car! (cddr exp) (cnst (caddr exp)))
		 (set-car! (cdddr exp) (cnst (cadddr exp)))
		 exp)))
;*--- typed-case ------------------------------------------------------*/
	 ((typed-case ?- ?test . ?clauses)
	  (set-car! (cddr exp) (cnst test))
	  (let loop ((hook clauses))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! (cdr (car hook))
			      (cnst (cadr (car hook))))
		    (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
	 ((begin . ?body)
	  (let loop ((hook body))
	     (if (null? (cdr hook))
		 (begin
		    (set-car! hook (cnst (car hook)))
		    exp)
		 (begin
		    (set-car! hook (cnst (car hook)))
		    (loop (cdr hook))))))
;*--- let -------------------------------------------------------------*/
	 ((let . ?-)
	  (let loop ((hook (cadr exp)))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (cnst (caddr exp)))
		 exp)
	      (begin
		 (set-car! (cdar hook)
			   (cnst (cadr (car hook))))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
	 ((labels . ?-)
	  (let loop ((hook (cadr exp)))
	     (if (null? hook)
		 (begin
		    (set-car! (cddr exp) (cnst (caddr exp)))
		    exp)
		 (begin
		    (set-car! (cddar hook)
			      (cnst (caddr (car hook))))
		    (function-body-set! (local-value (car (car hook)))
					(caddar hook))
		    (loop (cdr hook))))))
;*--- block -----------------------------------------------------------*/
	 ((block . ?-)
	  (set-car! (cddr exp) (cnst (caddr exp)))
	  exp)
;*--- return-from -----------------------------------------------------*/
	 ((return-from . ?-)
	  (set-car! (cddr exp) (cnst (caddr exp)))
	  exp)
;*--- apply -----------------------------------------------------------*/
	 ((apply . ?-)
	  (let liip ((hook (cdr exp)))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (cnst (car hook)))
		    (liip (cdr hook))))))
;*--- funcall ---------------------------------------------------------*/
	 ((funcall . ?-)
	  (let liip ((hook (cdr exp)))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (cnst (car hook)))
		    (liip (cdr hook))))))
;*--- application -----------------------------------------------------*/
	 (else
	  (cnst-application exp)))))

;*---------------------------------------------------------------------*/
;*    cnst-quote ...                                                   */
;*---------------------------------------------------------------------*/
(define (cnst-quote exp)
   (trace cnst "cnst-quote: " (shape exp) #\Newline)
   (cond
      ((null? exp)
       (abstract-nil))
      ((symbol? exp)
       (cnst-alloc-symbol exp))
      ((string? exp)
       (cnst-alloc-string exp))
      ((char? exp)
       (abstract-cchar->bchar exp))
      ((boolean? exp)
       (abstract-cbool->bbool exp))
      ((integer? exp)
       (abstract-cint->bint exp))
      ((real? exp)
       (abstract-cdouble->breal exp))
      ((pair? exp)
       (cnst-list exp))
      ((vector? exp)
       (cnst-vector exp))))

;*---------------------------------------------------------------------*/
;*    cnst-list ...                                                    */
;*---------------------------------------------------------------------*/
(define (cnst-list list)
   (let ((l (let loop ((pair list))
	       (cond
		  ((null? pair)
		   (abstract-nil))
		  ((not (pair? pair))
		   (cnst-quote pair))
		  (else
		   (abstract-cons (cnst-quote (car pair))
				  (loop (cdr pair))))))))
      (cnst-alloc-list l)))

;*---------------------------------------------------------------------*/
;*    cnst-vector ...                                                  */
;*---------------------------------------------------------------------*/
(define (cnst-vector vector)
   (abstract-list->vector (cnst-quote (vector->list vector))))

;*---------------------------------------------------------------------*/
;*    cnst-application ...                                             */
;*---------------------------------------------------------------------*/
(define (cnst-application exp)
   ;; on cnst tous les arguments
   (let liip ((hook exp))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (cnst (car hook)))
		    (liip (cdr hook)))))
   ;; on reconnait les cas triviaux.
   (let ((fun (car exp)))
      (cond
	 ((and (abstract-cstring->bstring? fun)
	       (string? (cadr exp)))
	  (cnst-alloc-string (cadr exp)))
	 ((and (abstract-csymbol->bsymbol? fun)
	       (symbol? (cadr exp)))
	  (cnst-alloc-symbol (cadr exp)))
	 ((and (abstract-cbool->bbool? fun)
	       (boolean? (cadr exp)))
	  (if (cadr exp)
	      (abstract-true)
	      (abstract-false)))
	 ((and (or (abstract-make-fx-procedure? fun)
		   (abstract-make-va-procedure? fun))
	       (=fx (cadddr exp) 0))
	  (cnst-alloc-procedure exp))
	 ((and (abstract-bbool->cbool? fun)
	       (pair? (cadr exp))
	       (abstract-cbool->bbool? (car (cadr exp))))
	  (cnst (cadr (cadr exp))))
	 ((abstract-bbool->cbool? fun)
	  (cond
	     ((abstract-true? (cadr exp))
	      #t)
	     ((abstract-false? (cadr exp))
	      #f)
	     (else
	      exp)))
	 ((and (abstract-cbool->bbool? fun)
	       (pair? (cadr exp))
	       (abstract-bbool->cbool? (car (cadr exp))))
	  (cnst (cadr (cadr exp))))
	 ((and (abstract-not? fun)
	       (pair? (cadr exp))
	       (abstract-not? (car (cadr exp))))
	  (cnst (cadr (cadr exp))))
	 ((and (abstract-cint->bint? fun)
	       (pair? (cadr exp))
	       (abstract-bint->cint? (car (cadr exp))))
	  (cnst (cadr (cadr exp))))
	 ((and (abstract-bint->cint? fun)
	       (pair? (cadr exp))
	       (abstract-cint->bint? (car (cadr exp))))
	  (cnst (cadr (cadr exp))))
	 (else
	  exp))))
