;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.2/Cgen/walk.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 10:18:07 1993                          */
;*    Last change :  Wed May 12 13:15:21 1993  (serrano)               */
;*                                                                     */
;*    La generation de code C                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_walk
   (include "Cgen/cgen.sch"
	    "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    var_env
	    engine_param
	    cgen_file
	    cgen_definition
	    cgen_identificator
	    cgen_main)
   (export  (cgen-walk tree)))

;*---------------------------------------------------------------------*/
;*    cgen-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (cgen-walk tree) 
   (verbose "   . Cgen" #\Newline)
   (start-partial-error "Cgen")
   (if (or (eq? *pass* 'ld) (eq? *pass* 'distrib))
       (set! tree (cons (make-bigloo-main) tree)))
   (let loop ((walk tree)
	      (res  '()))
      (if (null? walk)
	  (begin
	     (fail-if-partial-error)
	     (generate-c-file res))
	  (let ((var (car walk)))
	     (enter-function (shape var))
	     (let ((def (cgen-definition! var)))
		(leave-function)
		(loop (cdr walk) (cons def res)))))))

