;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.2/Cgen/s2c.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 11:59:39 1993                          */
;*    Last change :  Mon May  3 11:35:38 1993  (serrano)               */
;*                                                                     */
;*    On traduit du `sqil' en `C'                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_s2c
   (include "Var/variable.sch"
	    "Cgen/cgen.sch"
	    "Lift/lift.sch"
	    "Integ/integ.sch"
	    "Tools/trace.sch")
   (import  cgen_definition
	    scan_lexical
	    var_pragma
	    engine_param
	    tools_shape
	    tools_beta
	    tools_error)
   (export  (sqil->c exp kont)
	    (make-return-kont var)))

;*---------------------------------------------------------------------*/
;*    kid ...                                                          */
;*---------------------------------------------------------------------*/
(define (kid c-exp)
   c-exp)

;*---------------------------------------------------------------------*/
;*    stop-kont ...                                                    */
;*---------------------------------------------------------------------*/
(define (stop-kont c-exp)
   (match-case c-exp
      ((stop ?-)
       c-exp)
      ((set! . ?-)
       c-exp)
      (else
       `(stop ,c-exp))))
       
;*---------------------------------------------------------------------*/
;*    make-return-kont ...                                             */
;*---------------------------------------------------------------------*/
(define (make-return-kont var)
   (lambda (c-exp)
      (match-case c-exp
	 (nop
	  c-exp)
	 ((call ?to ?actuals)
	  (if (eq? to var)
	      (make-goto to actuals)
	      `(return ,c-exp)))
	 ((set! . ?-)
	  c-exp)
	 (else
	  `(return ,c-exp)))))

;*---------------------------------------------------------------------*/
;*    make-goto-kont ...                                               */
;*---------------------------------------------------------------------*/
(define (make-goto-kont label kont)
   (lambda (c-exp)
      (let ((c-exp (kont c-exp)))
	 (match-case c-exp
	    ((goto . ?-)
	     c-exp)
	    ((return . ?-)
	     c-exp)
	    (else
	     `(after ,c-exp
		     (goto ,label)))))))
   
;*---------------------------------------------------------------------*/
;*    make-set!-kont ...                                               */
;*---------------------------------------------------------------------*/
(define (make-set!-kont var k)
   (lambda (c-exp)
      (if (eq? var c-exp)
	  (k 'nop)
	  (if (and (pair? c-exp) (eq? (car c-exp) 'set!))
	      (k `(after ,c-exp (set! ,var ,(cadr c-exp))))
	      (k `(set! ,var ,c-exp))))))
 
;*---------------------------------------------------------------------*/
;*    make-cif-kont ...                                                */
;*---------------------------------------------------------------------*/
(define (make-cif-kont alors sinon kont)
   (let ((alors (sqil->c alors kont))
	 (sinon (sqil->c sinon kont)))
      (lambda (c-exp)
	 (if (and (not (pair? c-exp))
		  (not (local? c-exp))
		  (not (global? c-exp)))
	     (if c-exp
		 alors
		 sinon)
	     `(cif ,c-exp ,alors ,sinon)))))
 
;*---------------------------------------------------------------------*/
;*    make-typed-case-kont ...                                         */
;*---------------------------------------------------------------------*/
(define (make-typed-case-kont type clauses kont)
   (let loop ((hook clauses))
      (if (null? hook)
	  (lambda (c-exp)
	     `(typed-case ,type ,c-exp ,clauses))
	  (begin
	     (set-car! (cdr (car hook)) (sqil->c (cadr (car hook)) kont))
	     (loop (cdr hook))))))

;*---------------------------------------------------------------------*/
;*    find-formals-in-actuals ...                                      */
;*    -------------------------------------------------------------    */
;*    On recherce quels sont les formels qui apparaissent dans         */
;*    les actuels                                                      */
;*---------------------------------------------------------------------*/
(define (find-formals-in-actuals formals actuals)
   (define (find-in-one-actual res actual)
      (cond
	 ((null? actual)
	  res)
	 ((not (pair? actual))
	  (if (memq actual formals)
	      (begin
		 (set! formals (remq actual formals))
		 (cons actual res))
	      res))
	 (else
	  (find-in-one-actual (find-in-one-actual res (car actual))
			      (cdr actual)))))
   (let loop ((actuals actuals)
	      (res     '()))
      (if (null? actuals)
	  res
	  (loop (cdr actuals)
		(find-in-one-actual res (car actuals))))))
 
;*---------------------------------------------------------------------*/
;*    make-goto ...                                                    */
;*    -------------------------------------------------------------    */
;*    Afin d'etre sur de ne pas avoir de pbm, toutes les expressions   */
;*    qui apparaissent dans les formels et qui sont composees sont     */
;*    mises dans des variables temporaires                             */
;*---------------------------------------------------------------------*/
(define (make-goto to actuals)
   (trace cgen "make-goto: " (shape to) " " (shape actuals) #\Newline)
   (let (formals c-label)
      (define (do-goto actuals)
	 (trace cgen "do-goto: " (shape actuals) (shape formals) #\Newline)
	 (let loop ((formals formals)
		    (actuals actuals)
		    (sets    '()))
	    (cond
	       ((null? formals)
		`(begin ,@sets (goto ,c-label)))
	       ((eq? (car actuals) 'nop)
		(loop (cdr formals)
		      (cdr actuals)
		      sets))
	       (else
		(loop (cdr formals)
		      (cdr actuals)
		      (cons ((make-set!-kont (car formals) kid) (car actuals))
			    sets))))))
      (cond
	 ((global? to)
	  (set! c-label (cgen-c-label (global-info to)))
	  (set! formals (function-args (global-value to))))
	 ((eq? (local-class to) 'function)
	  (set! c-label (cgen-c-label (local-info to)))
	  (set! formals (function-args (local-value to))))
	 (else
	  (set! c-label (cgen-c-label (local-info to)))
	  (set! formals (return-args (local-value to)))))
      (let* ((actuals    (map (lambda (a f)
				 (if (eq? a f)
				     'nop
				     a))
			      actuals
			      formals))
	     (dangerous  (find-formals-in-actuals formals actuals))
	     (auxs       (map
			  (lambda (d)
			     (let ((aux (allocate-new-cgen (local-name d))))
				(cgen-type-set! (local-info aux)
						(short-type-of d))
				aux))
			  dangerous))
	     (d.a        (map cons dangerous auxs))
	     (auxs-init  (map (lambda (d a) `(set! ,a ,d))
			      dangerous
			      auxs)))
	 (trace cgen "dangerous: " (shape dangerous) #\Newline)
	 (if (null? dangerous)
	     (do-goto actuals)
	     (let ((new-actuals (map (lambda (a) (beta-reduce a d.a))
				     actuals)))
		`(let ,auxs ,auxs-init
		      ,(do-goto new-actuals)))))))

;*---------------------------------------------------------------------*/
;*    sqil->c ...                                                      */
;*---------------------------------------------------------------------*/
(define (sqil->c b-exp kont)
   (trace cgen "sqil->c: " (shape b-exp) #\Newline)
   (match-case b-exp
      ((atom ?-)
       (if (global? b-exp)
	   (get-global-cgen! b-exp))
       (kont b-exp))
      ((set! ?var ?val)
       (if (global? var)
	   (get-global-cgen! var))
       (sqil->c val (make-set!-kont var kont)))
      ((cif . ?-)
       (sqil->c.cif b-exp kont))
      ((typed-case ?type ?test . ?clauses)
       (let loop ((cl clauses))
	  (if (null? cl)
	      (sqil->c.actuals (list test)
			       (lambda (actuals)
				  (let ((actual (car actuals)))
				     (if (local? actual)
					 (cgen-type-set! (local-info actual)
							 type))
				     `(typed-case ,type ,actual ,clauses))))
	      (begin
		 (set-car! (cdr (car cl)) (sqil->c (cadr (car cl)) kont))
		 (loop (cdr cl))))))
      ((begin . ?body)
       (let loop ((hook (cdr b-exp)))
	  (if (null? (cdr hook))
	      (begin
		 (set-car! hook (sqil->c (car hook) kont))
		 b-exp)
	      (begin
		 (set-car! hook (sqil->c (car hook) stop-kont))
		 (loop (cdr hook))))))
      ((failure . ?-)
       (sqil->c.failure b-exp))
      ((let . ?-)
       (sqil->c.let b-exp kont))
      ((labels . ?-)
       (sqil->c.labels b-exp kont))
      ((funcall . ?-)
       (sqil->c.funcall b-exp kont))
      ((apply ?fun ?arg)
       ;; attention, `sqil->c.actuals' construit une liste inversee !
       (sqil->c.actuals (cdr b-exp)
			(lambda (actuals)
			   (set-car! (cdr b-exp) (cadr actuals))
			   (set-car! (cddr b-exp) (car actuals))
			   (kont b-exp))))
      ((continue . ?-)
       (sqil->c.continue b-exp kont))
      ((the-continuation)
       (sqil->c.the-continuation kont))
      ((block . ?-)
       (sqil->c.block b-exp kont))
      ((gblock . ?-)
       (sqil->c.gblock b-exp kont))
      ((return-from . ?-)
       (sqil->c.return-from b-exp kont))
      ((greturn-from . ?-)
       (sqil->c.greturn-from b-exp kont))
      ((tailcall . ?-)
       (sqil->c.tailcall b-exp kont))
      (else
       (sqil->c.call b-exp kont))))

;*---------------------------------------------------------------------*/
;*    get-new-label ...                                                */
;*---------------------------------------------------------------------*/
(define get-new-label
   (let ((counter -1))
      (lambda (string)
	 (set! counter (+fx 1 counter))
	 (string-append string
			(string-append "_" (integer->string counter))))))
	  
;*---------------------------------------------------------------------*/
;*    sqil->c.cif ...                                                  */
;*---------------------------------------------------------------------*/
(define (sqil->c.cif b-exp kont)
   (let ((si (cadr b-exp)))
      (if (or (not (pair? si))
	      (or (local? (car si))
		  (global? (car si))))
	  (sqil->c.simple-cif b-exp kont)
	  (sqil->c.compound-cif b-exp kont))))

;*---------------------------------------------------------------------*/
;*    sqil->c.simple-cif ...                                           */
;*---------------------------------------------------------------------*/
(define (sqil->c.simple-cif b-exp kont)
   (let ((si    (cadr b-exp))
	 (alors (caddr b-exp))
	 (sinon (cadddr b-exp)))
      (sqil->c si (make-cif-kont alors sinon kont))))

;*---------------------------------------------------------------------*/
;*    sqil->c.compound-cif ...                                         */
;*---------------------------------------------------------------------*/
(define (sqil->c.compound-cif b-exp kont)
   (let* ((si    (cadr b-exp))
	  (alors (caddr b-exp))
	  (sinon (cadddr b-exp))
	  (alors? #f)
	  (sinon? #f)
	  (alors-label (get-new-label "_true"))
	  (sinon-label (get-new-label "_false"))
	  (endif-label (get-new-label "_endif"))
	  (test (sqil->c si
			 (lambda (c-exp)
			    (if (and (not (pair? c-exp))
				     (not (local? c-exp))
				     (not (global? c-exp)))
				(cond
				   (c-exp
				    (set! alors? #t)
				    `(goto ,alors-label))
				   (else
				    (set! sinon? #t)
				    `(goto ,sinon-label)))
				(begin
				   (set! alors? #t)
				   (set! sinon? #t)
				   `(cif ,c-exp
					 (goto ,alors-label)
					 (goto ,sinon-label))))))))

	      (cond
		 ((and (not alors?) (not sinon?))
		  test)
		 ((not alors?)
		  (sqil->c sinon kont))
		 ((not sinon?)
		  (sqil->c alors kont))
		 (else
		  `(branch ,test
			   (,alors-label
			    ,(sqil->c alors (make-goto-kont endif-label kont)))
			   (,sinon-label ,(sqil->c sinon kont))
			   ,endif-label)))))
	
;*---------------------------------------------------------------------*/
;*    sqil->c.failure ...                                              */
;*---------------------------------------------------------------------*/
(define (sqil->c.failure b-exp)
   (sqil->c.actuals (cdr b-exp)
		    (lambda (actuals)
		       `(failure ,(reverse! actuals)))))
 
;*---------------------------------------------------------------------*/
;*    sqil->c.funcall ...                                              */
;*---------------------------------------------------------------------*/
(define (sqil->c.funcall b-exp kont)
   (set-car! (cdr b-exp) (sqil->c (cadr b-exp) kid))
   (sqil->c.actuals (cddr b-exp)
		    (lambda (actuals)
		       (kont `(funcall ,(cadr b-exp)
				       ,(reverse! actuals))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.let ...                                                  */
;*---------------------------------------------------------------------*/
(define (sqil->c.let b-exp kont)
   (let loop ((bindings (cadr b-exp))
	      (vars     '())
	      (vals     '()))
      (if (null? bindings)
	  `(let ,vars ,vals ,(sqil->c (caddr b-exp) kont))
	  (let ((binding (car bindings)))
	     (get-local-cgen! (car binding))
	     (cgen-type-set!  (local-info (car binding))
			      (short-type-of (cadr binding)))
	     (loop (cdr bindings)
		   (cons (car binding) vars)
		   (cons (sqil->c `(set! ,(car binding) ,(cadr binding)) kid)
			 vals))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.labels ...                                               */
;*---------------------------------------------------------------------*/
(define (sqil->c.labels b-exp kont)
   (if *gcc*
       (sqil->c.gcc-labels b-exp kont)
       (sqil->c.ansi-labels b-exp kont)))

;*---------------------------------------------------------------------*/
;*    sqil->c.gcc-labels ...                                           */
;*---------------------------------------------------------------------*/
(define (sqil->c.gcc-labels b-exp kont)
   (set-car! b-exp 'gcc-labels)
   (let loop ((bindings (cadr b-exp)))
      (if (null? bindings)
	  (begin
	     (set-car! (cddr b-exp) (sqil->c (caddr b-exp) kont))
	     b-exp)
	  (let* ((binding (car bindings))
		 (fun     (car binding))
		 (formals (cadr binding))
		 (body    (caddr binding)))
	     (get-local-cgen! fun)
	     (for-each get-local-cgen! formals)
	     (let ((body `(begin
			     (label ,(cgen-c-label (local-info fun)))
			     ,(sqil->c body (make-return-kont fun)))))
		(set-car! (cddr binding) body)
		(cgen-c-abstract-code-set! (local-info fun) body)
		(cgen-c-args-set!          (local-info fun) formals)
		(loop (cdr bindings)))))))
	  
;*---------------------------------------------------------------------*/
;*    sqil->c.ansi-labels ...                                          */
;*    -------------------------------------------------------------    */
;*    On se contente ici d'ouvrir un bloc pour declarer tous les       */
;*    parametres formels et marquer que les fonctions locales n'ont    */
;*    pas encore ete expansees.                                        */
;*---------------------------------------------------------------------*/
(define (sqil->c.ansi-labels b-exp kont)
   (let loop ((bindings     (cadr b-exp))
	      (all-formals  '()))
      (if (null? bindings)
	  `(let ,all-formals ()
		,(sqil->c (caddr b-exp) kont))
	  (let* ((binding (car bindings))
		 (local   (car binding))
		 (formals (cadr binding)))
	     (get-local-cgen! local)
	     (for-each get-local-cgen! formals)
	     (cgen-c-abstract-code-set! (local-info local) '())
	     (cgen-c-args-set!          (local-info local) formals)
	     (loop (cdr bindings)
		   (append formals all-formals))))))
	 
;*---------------------------------------------------------------------*/
;*    sqil->c.continue ...                                             */
;*---------------------------------------------------------------------*/
(define (sqil->c.continue b-exp kont)
   (sqil->c (cadr b-exp)
	    (lambda (e)
	       (sqil->c (caddr b-exp)
			(lambda (v)
			   `(longjmp ,e ,v))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.the-continuation ...                                     */
;*---------------------------------------------------------------------*/
(define (sqil->c.the-continuation kont)
   (let ((new-buf (allocate-new-cgen 'jmp_buf)))
      (cgen-type-set! (local-info new-buf) 'cjmp_buf)
      `(setjmp ,new-buf ,(kont `(jmpbuf->bobj ,new-buf)))))
   
;*---------------------------------------------------------------------*/
;*    sqil->c.block ...                                                */
;*---------------------------------------------------------------------*/
(define (sqil->c.block b-exp kont)
   (if *gcc*
       (sqil->c.gcc-block b-exp kont)
       (sqil->c.ansi-block b-exp kont)))

;*---------------------------------------------------------------------*/
;*    sqil->c.gcc-block ...                                            */
;*---------------------------------------------------------------------*/
(define (sqil->c.gcc-block b-exp kont)
   (let ((G? (lift-G? (local-info (cadr b-exp)))))
      (get-local-cgen! (cadr b-exp))
      (cgen-G?-set! (local-value (cadr b-exp)) G?)
      (sqil->c (cadr b-exp) (lambda (c)
			       (cgen-type-set! (local-info (cadr b-exp))
					       'cjmp_buf)
			       `(setjmp ,c ,(sqil->c (caddr b-exp) kont))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.ansi-block ...                                           */
;*---------------------------------------------------------------------*/
(define (sqil->c.ansi-block b-exp kont)
   (get-local-cgen! (cadr b-exp))
   (sqil->c (cadr b-exp)
	    (lambda (c)
	       `(catch ,(sqil->c (caddr b-exp)
				 (lambda (v)
				    `(shortjmp ,c
					       ,v)))
		       (label ,(cgen-c-label (local-info c)))
		       ,(kont '(get-block-value))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.gblock ...                                               */
;*---------------------------------------------------------------------*/
(define (sqil->c.gblock b-exp kont)
   (sqil->c (cadr b-exp)
	    (lambda (c)
	       (cgen-type-set! (local-info (cadr b-exp)) 'cjmp_buf)
	       `(setjmp ,c ,(sqil->c (caddr b-exp) kont)))))

;*---------------------------------------------------------------------*/
;*    sqil->c.return-from ...                                          */
;*---------------------------------------------------------------------*/
(define (sqil->c.return-from b-exp kont)
   ;; normalement on ne peut pas avoir de return-from si la variable
   ;; est globalise (car lift genere un continue dans ce cas)
   (if *gcc*
       (sqil->c.gcc-return-from b-exp kont)
       (sqil->c.ansi-return-from b-exp kont)))
   
;*---------------------------------------------------------------------*/
;*    sqil->c.gcc-return-from ...                                      */
;*---------------------------------------------------------------------*/
(define (sqil->c.gcc-return-from b-exp kont)
   (sqil->c (cadr b-exp)
	    (lambda (e)
	       (sqil->c (caddr b-exp)
			(lambda (c)
			   (if (or (and (cgen? (local-info (cadr b-exp)))
					(cgen-G? (local-info (cadr b-exp))))
				   (lift-G? (local-info (cadr b-exp))))
			       (error "sqil->c.return-from"
				      "Illegal return-form"
				      (shape b-exp))
			       `(shortjmp ,e
					  ,c)))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.ansi-return-from ...                                     */
;*---------------------------------------------------------------------*/
(define (sqil->c.ansi-return-from b-exp kont)
   (sqil->c (cadr b-exp)
	    (lambda (e)
	       (sqil->c (caddr b-exp)
			(lambda (c)
			   `(shortjmp ,e ,c))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.greturn-from ...                                         */
;*---------------------------------------------------------------------*/
(define (sqil->c.greturn-from b-exp kont)
   (sqil->c (cadr b-exp)
	    (lambda (e)
	       (sqil->c (caddr b-exp)
			(lambda (c)
			   `(longjmp ,e ,c))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.tailcall ...                                             */
;*---------------------------------------------------------------------*/
(define (sqil->c.tailcall b-exp kont)
   (let* ((var  (cadr b-exp))
	  (cgen (local-info var)))
      (if (null? (cgen-c-abstract-code cgen))
	  ;; on integre le corps de la fonction
	  (begin
	     ;; il faut marquer qu'on est en train d'integrer ce code
	     ;; avant d'explorer la fonction. Si on ne fait pas ca, on
	     ;; boucle sur les appels recursifs.
	     (cgen-c-abstract-code-set! cgen #t)
	     (cgen-c-abstract-code-set! cgen
					`(after (label ,(cgen-c-label cgen))
						,(sqil->c (function-body
							   (local-value var))
							  kont)))
	     (sqil->c.actuals (cddr b-exp)
			      (lambda (actuals)
				 `(begin
				     ,@(map (lambda (vars vals)
					       `(set! ,vars ,vals))
					    (function-args (local-value var))
					    (reverse! actuals))
				     ,(cgen-c-abstract-code cgen)))))
	  (sqil->c.actuals (cddr b-exp)
			   (lambda (actuals)
			      (make-goto (cadr b-exp) (reverse! actuals)))))))
	  
;*---------------------------------------------------------------------*/
;*    sqil->c.call ...                                                 */
;*---------------------------------------------------------------------*/
(define (sqil->c.call b-exp kont)
   (if (global? (car b-exp))
       (get-global-cgen! (car b-exp)))
   (sqil->c.actuals (cdr b-exp)
		    (lambda (actuals)
		       (let ((actuals (reverse! actuals)))
			  (kont `(call ,(car b-exp) ,actuals))))))

;*---------------------------------------------------------------------*/
;*    sqil->c.actuals ...                                              */
;*---------------------------------------------------------------------*/
(define (sqil->c.actuals actuals kont)
   (let loop ((actuals     actuals)
	      (new-actuals '())
	      (aux-init    '())
	      (aux         '()))
      (if (null? actuals)
	  (if (null? aux)
	      (kont new-actuals)
	      `(let ,aux ,aux-init ,(kont new-actuals)))
	  (let ((actual (car actuals)))
	     (if (and (pair? actual)
		      (not (imbricable? actual)))
		 ;; c'est un appel compose, on passe par une variable
		 (let* ((aux-var (allocate-new-cgen 'aux))
			(aux-val (sqil->c `(set! ,aux-var ,actual) kid)))
		    (cgen-type-set! (local-info aux-var)
				    (short-type-of (car actuals)))
		    (loop (cdr actuals)
			  (cons aux-var new-actuals)
			  (cons aux-val aux-init)
			  (cons aux-var aux)))
		 (loop (cdr actuals)
		       (cons (sqil->c (car actuals) kid) new-actuals)
		       aux-init
		       aux))))))

;*---------------------------------------------------------------------*/
;*    imbricable? ...                                                  */
;*---------------------------------------------------------------------*/
(define (imbricable? exp)
   (and (global? (car exp))
	(pragma-imbricable? (car exp))
	(let loop ((formals (cdr exp)))
	   (cond
	      ((null? formals)
	       #t)
	      ((pair? (car formals))
	       (if (imbricable? (car formals))
		   (loop (cdr formals))
		   #f))
	      (else
	       (loop (cdr formals)))))))

;*---------------------------------------------------------------------*/
;*    allocate-new-cgen                                                */
;*---------------------------------------------------------------------*/
(define (allocate-new-cgen name)
   (let ((new (cdar (allocate-local-variables (list name)))))
      (get-local-cgen! new)
      new))

;*---------------------------------------------------------------------*/
;*    short-type-of                                                    */
;*---------------------------------------------------------------------*/
(define (short-type-of exp)
   (match-case exp
      ((?fun . ?-)
       (if (and (global? fun) 
		(eq? (global-class fun) 'foreign))
	   (case (foreign-class (global-value fun))
	      ((function macro-function)
	       (cadr (foreign-type (global-value (car exp)))))
	      (else
	       (partial-error "" "Illegal foreign application" (shape exp))))
	   'bobj))
      (else
       (if (local? exp)
	   (cgen-type (local-info exp))
	   'bobj))))
