;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.3/Cgen/ident.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 10:31:11 1993                          */
;*    Last change :  Mon Jun 14 15:20:50 1993  (serrano)               */
;*                                                                     */
;*    On traduit les noms Scheme en noms C                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_identificator
   (include "Var/variable.sch")
   (foreign (int get-hash-number (string) "get_hash_number"))
   (export  (c-global-id global)
	    (c-local-id  local)))

;*---------------------------------------------------------------------*/
;*    c-global-id ...                                                  */
;*---------------------------------------------------------------------*/
(define (c-global-id global)
   (if (string? (global-c-name global))
       (global-c-name global)
       (scheme-id->c-id (string-append
			 (symbol->string (global-name global))
			 "@"
			 (symbol->string (global-module global))))))

;*---------------------------------------------------------------------*/
;*    c-local-id ...                                                   */
;*---------------------------------------------------------------------*/
(define (c-local-id local)
   (scheme-id->c-id (string-append (symbol->string (local-name local))
				   "@"
				   (integer->string (local-key local)))))

;*---------------------------------------------------------------------*/
;*    scheme-id->c-id ...                                              */
;*    string --> string                                               */
;*---------------------------------------------------------------------*/
(define (scheme-id->c-id string)
   (let* ((string (if (not (char-alphabetic? (string-ref string 0)))
		      (string-append "_" string)
		      string))
	  (len    (string-length string))
	  (rg     #f)
	  (res    (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     (if rg
		 (string-append
		  res 
		  (string-append
		   "_"
		   (integer->string (get-hash-number string))))
		 res)
	     (let ((c (string-ref string i)))
		(cond
		   ((memq c '(#\? #\# #\* #\! #\. #\- #\& #\| #\^
				  #\> #\< #\+ #\@ #\= #\/ #\: #\\ #\space))
		    (set! rg #t)
		    (string-set! res i #\_) 
		    (loop (+fx i 1)))
		   (else
		    (string-set! res i (string-ref string i))
		    (loop (+fx i 1)))))))))

