;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Cgen/file.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 09:46:25 1993                          */
;*    Last change :  Thu May  6 15:56:21 1993  (serrano)               */
;*                                                                     */
;*    On genere le fichier C                                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_file
   (include "Tools/trace.sch")
   (import  engine_param
	    tools_file
	    tools_hash
	    var_env
	    cgen_emit
	    cgen_definition)
   (export  (generate-c-file tree)))

;*---------------------------------------------------------------------*/
;*    generate-c-file tree) ...                                        */
;*---------------------------------------------------------------------*/
(define (generate-c-file tree)
   (let* ((preffix   (if (and (string? *dest*)
			      (pair? (memq *pass* '(cgen distrib cc))))
			 (remove-extansion *dest*)
			 (if (string? *src*)
			     (remove-extansion *src*)
			     (error "generate-c-file"
				    "no destination name"
				    *dest*))))
	  (file-name (string-append preffix ".c"))
	  (c-port    (open-output-file file-name)))
      (if (not (output-port? c-port))
	  (error "generate-c-file" "Can't open output-file" file-name))
      ;; on construit le header du fichier
      (emit-c-header c-port file-name)
      ;; les fichies includes
      (emit-c-include c-port)
      ;; on declare les variables globales utilisees
      (walk-on-hash-table! (lambda (bucket)
			      (let loop ((bucket bucket))
				 (if (null? bucket)
				     'done
				     (begin
					(emit-c-prototype c-port (car bucket))
					(loop (cdr bucket))))))
			   *Genv*
			   'genv)
      (newline c-port)
      ;; on delcare les locales globalisees
      (for-each (lambda (local) (emit-c-local-prototype c-port local))
		(get-local-definitions))
      (newline c-port)
      ;; on genere (eventuellement le code main)
      (if (or (eq? *pass* 'ld) (eq? *pass* 'distrib))
	  (emit-c-main c-port))
      ;; on emet le code C produit
      (for-each (lambda (def) (emit-c-definition c-port def)) tree)
      ;; ok, on termine
      (close-output-port c-port)
      preffix))
