;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.3/Cgen/emit.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 09:55:16 1993                          */
;*    Last change :  Tue Jun 15 09:05:57 1993  (serrano)               */
;*                                                                     */
;*    On emet des ondes C                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_emit
   (include "Var/variable.sch"
	    "Cgen/cgen.sch")
   (import  engine_param
	    var_env
	    heap_abstract
	    type_name
	    write_c
	    cgen_c-emit)
   (export  (emit-c-header port file-name)
	    (emit-c-include port)
	    (emit-c-prototype port global)
	    (emit-c-local-prototype port local)
	    (emit-c-main port)
	    (emit-c-definition port def)
	    (emit-c-list port list)
	    (emit-c-declaration port list)
	    (emit-c-type port type)))

;*---------------------------------------------------------------------*/
;*    emit-c-header ...                                                */
;*---------------------------------------------------------------------*/
(define (emit-c-header port file-name)
   (write-c-comment port "" #\= 73)
   (write-c-comment port file-name #\space 73)
   (write-c-comment port *bigloo-name* #\space 73)
   (write-c-comment port (string-append *bigloo-author*
				   (string-append " (c)            "
						  *bigloo-date*))
		    #\space 73)
   (write-c-comment port "" #\= 73))

;*---------------------------------------------------------------------*/
;*    emit-c-include ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-c-include port)
      (for-each (lambda (i) (fprint port "#include <" i ">"))
		(reverse! *include-foreign*))
      (newline port))

;*---------------------------------------------------------------------*/
;*    emit-c-prototypes ...                                            */
;*---------------------------------------------------------------------*/
(define (emit-c-prototype port global)
   (define (emit-c-foreign-prototype global)
      (let ((foreign (global-value global)))
	 (cond
	    ((or (eq? (foreign-class foreign) 'macro-function)
		 (eq? (foreign-class foreign) 'macro-cnst))
	     'nothing)
	    ((eq? (foreign-class foreign) 'variable)
	     (display "extern " port)
	     (emit-c-type port (foreign-type foreign))
	     (fprint port " " (global-c-name global) ";"))
	    (else
	     (display "extern " port)
	     (emit-c-type port (cadr (foreign-type foreign)))
	     (fprint port " " (global-c-name global) "();")))))
   (define (emit-c-bigloo-prototype global)
      (case (global-import global)
	 ((top-level)
	  'nothing)
	 ((import)
	  (display "extern " port))
	 ((export)
	  (if (eq? (global-class global) 'function)
	      (display "extern " port)))
	 (else
	  (display "static " port)))
      (emit-c-type port 'bobj)
      (write-char #\space port)
      (display (cgen-c-name (global-info global)) port)
      (cond
	 ((eq? (global-class global) 'variable)
	  (if (eq? (global-import global) 'import)
	      (fprint port #\;)
	      (fprint port " = " (global-c-name (abstract-unspecified)) ";")))
	 (else
	  (fprint port "();"))))
   (if (not (cgen? (global-info global)))
       'nothing
       (if (eq? (global-class global) 'foreign)
	   (emit-c-foreign-prototype global)
	   (emit-c-bigloo-prototype global))))

;*---------------------------------------------------------------------*/
;*    emit-c-local-prototype ...                                       */
;*---------------------------------------------------------------------*/
(define (emit-c-local-prototype port local)
   (display "static " port)
   (emit-c-type port 'bobj)
   (fprint port #\space (cgen-c-name (local-info local)) "();"))
   
;*---------------------------------------------------------------------*/
;*    emit-c-type ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-type port type)
   (display (bigloo-type->c-type type) port))

;*---------------------------------------------------------------------*/
;*    emit-c-definition ...                                            */
;*---------------------------------------------------------------------*/
(define (emit-c-definition port var)
   (let (value cgen (static #t))
      (if (global? var)
	  (begin
	     (if (eq? (global-import var) 'export)
		 (set! static #f))
	     (set! value (global-value var))
	     (set! cgen (global-info var)))
	  (begin
	     (set! value (local-value var))
	     (set! cgen (local-info var))))
      (if static
	  (display "static " port))
      (emit-c-type port 'bobj)
      (newline port)
      (let ((ansi? *ansi-cc*))
	 (fprint port "#if defined( __STDC__ )")
	 (begin
	    (set! *ansi-cc* #t)
	    (display (cgen-c-name cgen) port)
	    (emit-c-formals port (cgen-c-args cgen)))
	 (fprint port "\n#else")
	 (begin
	    (set! *ansi-cc* #f)
	    (display (cgen-c-name cgen) port)
	    (emit-c-formals port (cgen-c-args cgen)))
	 (set! *ansi-cc* ansi?))
      (fprint port "#endif")
      (emit-c-exp port (cgen-c-abstract-code cgen))
      (newline port)
      (newline port)))

;*---------------------------------------------------------------------*/
;*    emit-c-formals ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-c-formals port formals)
   (if (not *ansi-cc*)
       (begin
	  (emit-c-list port formals)
	  (newline port)
	  (emit-c-declaration port formals))
       (begin
	  (write-char #\( port)
	  (if (null? formals)
	      (write-char #\) port)
	      (let loop ((formals formals))
		 (emit-c-type port (cgen-type (local-info (car formals))))
		 (write-char #\space port)
		 (display (cgen-c-name (local-info (car formals))) port)
		 (if (null? (cdr formals))
		     (write-char #\) port)
		     (begin
			(write-char #\, port)
			(loop (cdr formals)))))))))

;*---------------------------------------------------------------------*/
;*    emit-c-list ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-list port list)
   (cond
      ((null? list)
       (display "()" port))
      ((null? (cdr list))
       (display "( " port)
       (emit-c-exp port (car list))
       (display " )" port))
      (else
       (display "( " port)
       (let loop ((list list))
	  (if (null? (cdr list))
	      (begin
		 (emit-c-exp port (car list))
		 (display " )" port))
	      (begin
		 (emit-c-exp port (car list))
		 (display ", " port)
		 (loop (cdr list))))))))

;*---------------------------------------------------------------------*/
;*    emit-c-declaration ...                                           */
;*---------------------------------------------------------------------*/
(define (emit-c-declaration port formals)
   (define (emit-formals-of-type type sep formals)
      (emit-c-type port type)
      (let loop ((sep     sep)
		 (formals formals))
	 (cond
	    ((null? formals)
	     (fprint port ";")
	     '())
	    ((not (eq? (cgen-type (local-info (car formals))) type))
	     (fprint port ";")
	     formals)
	    (else
	     (display sep port)
	     (display (cgen-c-name (local-info (car formals))) port)
	     (loop ", " (cdr formals))))))
   (if (null? formals)
       'done
       (labels ()
          (let loop ((formals formals))
             (if (null? formals)
                 'done
                 (loop (emit-formals-of-type (cgen-type
					      (local-info (car formals)))
                                            #\space
                                            formals)))))))

;*---------------------------------------------------------------------*/
;*    emit-c-main ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-main port)
   (fprint port "main( argc, argv )")
   (fprint port "int argc; char *argv[];")
   (fprint port "{_bigloo_main( argc, argv );}"))
