;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../emit-code.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 13:13:36 1993                          */
;*    Last change :  Fri Jun 11 08:00:51 1993  (serrano)               */
;*                                                                     */
;*    On emet du C d'apres la syntaxe abstraite.                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_c-emit
   (include "Var/variable.sch"
	    "Cgen/cgen.sch"
	    "Tools/trace.sch")
   (import  tools_trace
	    tools_shape
	    cgen_emit)
   (export  (emit-c-exp port c-exp)))

;*---------------------------------------------------------------------*/
;*    emit-c-exp ...                                                   */
;*---------------------------------------------------------------------*/
(define (emit-c-exp port c-exp)
   (trace cgen "emit-c-exp: " (shape c-exp) #\Newline)
   (if (not (pair? c-exp))
       (emit-c-atom port c-exp)
       (case (car c-exp)
	  ((stop)
	   (emit-c-stop port c-exp))
	  ((label)
	   (emit-c-label port (cadr c-exp)))
	  ((failure)
	   (emit-c-failure port c-exp))
	  ((begin)
	   (emit-c-begin port c-exp))
	  ((return)
	   (emit-c-return port c-exp))
	  ((cif)
	   (emit-c-cif port c-exp))
	  ((branch)
	   (emit-c-branch port c-exp))
	  ((after)
	   (emit-c-after port c-exp))
	  ((typed-case)
	   (emit-c-typed-case port c-exp))
	  ((set!)
	   (emit-c-set! port c-exp))
	  ((let)
	   (emit-c-let port c-exp))
	  ((gcc-labels)
	   (emit-gcc-labels port c-exp))
	  ((funcall)
	   (emit-c-funcall port c-exp))
	  ((apply)
	   (emit-c-apply port c-exp))
	  ((goto)
	   (emit-c-goto port c-exp))
	  ((get-block-value)
	   (emit-c-get-block-value port))
	  ((catch)
	   (emit-c-catch port c-exp))
	  ((setjmp)
	   (emit-c-setjmp port c-exp))
	  ((longjmp)
	   (emit-c-longjmp port c-exp))
	  ((shortjmp)
	   (emit-c-shortjmp port c-exp))
	  ((jmpbuf->bobj)
	   (emit-c-jmpbuf->bobj port c-exp))
	  ((call)
	   (emit-c-call port c-exp)))))

;*---------------------------------------------------------------------*/
;*    emit-c-atom ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-atom port c-exp)
   (cond
      ((local? c-exp)
       (display (cgen-c-name (local-info c-exp)) port))
      ((global? c-exp)
       (display (cgen-c-name (global-info c-exp)) port))
      ((eq? c-exp 'nop)
       (write-char #\; port))
      ((eq? c-exp #t)
       (display "((unsigned char)1)" port))
      ((eq? c-exp #f)
       (display "((unsigned char)0)" port))
      ((char? c-exp)
       (write-char #\' port)
       (if (=fx (char->integer c-exp) 39)
	   (display "\\''" port)
	   (begin
	      (case c-exp
		 ((#\tab)
		  (write-char #\\ port)
		  (write-char #\t port))
		 ((#\newline)
		  (write-char #\\ port)
		  (write-char #\n port))
		 ((#\\)
		  (write-char #\\ port)
		  (write-char #\\ port))
		 (else
		  (write-char c-exp port)))
	      (write-char #\' port))))
      (else
       (write c-exp port))))

;*---------------------------------------------------------------------*/
;*    emit-c-stop ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-stop port c-exp)
   (emit-c-exp port (cadr c-exp))
   (write-char #\; port))

;*---------------------------------------------------------------------*/
;*    emit-c-failure ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-c-failure port c-exp)
   (display "FAILURE" port)
   (emit-c-list port (cadr c-exp))
   (write-char #\; port))
  
;*---------------------------------------------------------------------*/
;*    emit-c-begin ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-c-begin port c-exp)
   (if (null? (cddr c-exp))
       (emit-c-exp port (cadr c-exp))
       (begin
	  (write-char #\{ port)
	  (newline port)
	  (let loop ((list (cdr c-exp)))
	     (cond
		((null? list)
		 (write-char #\} port))
		(else
		 (emit-c-exp port (car list))
		 (newline port)
		 (loop (cdr list))))))))
   
;*---------------------------------------------------------------------*/
;*    emit-c-label ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-c-label port c-exp)
   (display c-exp port)
   (display ":" port)
   (newline port))
   
;*---------------------------------------------------------------------*/
;*    emit-c-return ...                                                */
;*---------------------------------------------------------------------*/
(define (emit-c-return port c-exp)
   (display "return " port)
   (emit-c-exp port (cadr c-exp))
   (display ";" port))

;*---------------------------------------------------------------------*/
;*    emit-c-cif ...                                                   */
;*---------------------------------------------------------------------*/
(define (emit-c-cif port c-exp)
   (let ((si    (cadr c-exp))
	 (alors (caddr c-exp))
	 (sinon (cadddr c-exp)))
      (display "if( " port)
      (emit-c-exp port si)
      (write-char #\) port)
      (newline port)
      (emit-c-exp port alors)
      (display "else" port)
      (newline port)
      (emit-c-exp port sinon)))

;*---------------------------------------------------------------------*/
;*    emit-c-branch ...                                                */
;*---------------------------------------------------------------------*/
(define (emit-c-branch port c-exp)
   (let ((test        (cadr c-exp))
	 (true-label  (caddr c-exp))
	 (false-label (cadddr c-exp))
	 (endif-label (cadddr (cdr c-exp))))
      (write-char #\{ port)
      (emit-c-exp port test) 
      (emit-c-label port (car true-label))
      (emit-c-exp port (cadr true-label))
      (emit-c-label port (car false-label))
      (emit-c-exp port (cadr false-label))
      (emit-c-label port endif-label)
      (write-char #\; port)
      (newline port)
      (write-char #\} port)))

;*---------------------------------------------------------------------*/
;*    emit-c-after ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-c-after port c-exp)
   (write-char #\{ port)
   (emit-c-exp port (cadr c-exp))
   (newline port)
   (emit-c-exp port (caddr c-exp))
   (write-char #\} port))
     
;*---------------------------------------------------------------------*/
;*    emit-c-typed-case ...                                            */
;*---------------------------------------------------------------------*/
(define (emit-c-typed-case port c-exp)
   (display "switch( " port)
   (write-char #\( port)
   (emit-c-type port (cadr c-exp))
   (write-char #\) port)
   (emit-c-exp port (caddr c-exp))
   (write-char #\) port)
   (write-char #\{ port)
   (let loop ((clauses (cadddr c-exp)))
      (let ((clause (car clauses)))
	 (if (eq? (car clause) 'else)
	     (begin
		(display "default: " port)
		(newline port)
		(emit-c-exp port (cadr clause))
		(write-char #\} port))
	     (begin
		(for-each (lambda (t)
			     (display "case " port)
			     (emit-c-exp port t)
			     (display " : " port)
			     (newline port))
			  (car clause))
		(emit-c-exp port (cadr clause))
		(display "break;" port)
		(loop (cdr clauses)))))))

;*---------------------------------------------------------------------*/
;*    emit-c-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-set! port c-exp)
   (emit-c-exp port (cadr c-exp))
   (write-char #\= port)
   (emit-c-exp port (caddr c-exp))
   (write-char #\; port))

;*---------------------------------------------------------------------*/
;*    emit-c-let ...                                                   */
;*---------------------------------------------------------------------*/
(define (emit-c-let port c-exp)
   (let ((var  (cadr c-exp))
	 (val  (caddr c-exp))
	 (body (cadddr c-exp)))
      (write-char #\{ port)
      (emit-c-declaration port var)
      (for-each (lambda (v) (emit-c-exp port v)) val)
      (emit-c-exp port body)
      (write-char #\} port)))

;*---------------------------------------------------------------------*/
;*    emit-gcc-labels ...                                              */
;*---------------------------------------------------------------------*/
(define (emit-gcc-labels port c-exp)
   (write-char #\{ port)
   (for-each (lambda (d) (emit-c-local-prototype port (car d))) (cadr c-exp))
   (newline port)
   (for-each (lambda (d) (emit-c-definition port (car d))) (cadr c-exp))
   (emit-c-exp port (caddr c-exp))
   (write-char #\} port))

;*---------------------------------------------------------------------*/
;*    emit-c-funcall ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-c-funcall port c-exp)
   (display "PROCEDURE_ENTRY( " port)
   (emit-c-exp port (cadr c-exp))
   (display " )" port)
   (emit-c-list port (caddr c-exp)))

;*---------------------------------------------------------------------*/
;*    emit-c-apply ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-c-apply port c-exp)
   (display "apply( " port)
   (emit-c-exp port (cadr c-exp))
   (write-char #\, port)
   (emit-c-exp port (caddr c-exp))
   (display " )" port))

;*---------------------------------------------------------------------*/
;*    emit-c-goto ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-goto port c-exp)
   (display "goto " port)
   (display (cadr c-exp) port)
   (write-char #\; port))

;*---------------------------------------------------------------------*/
;*    emit-c-catch ...                                                 */
;*---------------------------------------------------------------------*/
(define (emit-c-catch port c-exp)
   (emit-c-exp port (cadr c-exp))
   (emit-c-label port (cadr (caddr c-exp)))
   (emit-c-exp port (cadddr c-exp)))

;*---------------------------------------------------------------------*/
;*    emit-c-get-block-value ...                                       */
;*---------------------------------------------------------------------*/
(define (emit-c-get-block-value port)
   (display "__ContinueValue" port))

;*---------------------------------------------------------------------*/
;*    emit-c-setjmp ...                                                */
;*---------------------------------------------------------------------*/
(define (emit-c-setjmp port c-exp)
   (write-char #\{ port)
   (emit-c-type port (cgen-type (local-info (cadr c-exp))))
   (write-char #\space port)
   (display (cgen-c-name (local-info (cadr c-exp))) port)
   (write-char #\; port)
   (display "if( _setjmp( (JMP_BUF *)" port)
   (display (cgen-c-name (local-info (cadr c-exp))) port)
   (display " ) )" port)
   (display "return __ContinueValue;" port)
   (newline port)
   (display "else" port)
   (newline port)
   (emit-c-exp port (caddr c-exp))
   (write-char #\} port))

;*---------------------------------------------------------------------*/
;*    emit-c-longjmp ...                                               */
;*---------------------------------------------------------------------*/
(define (emit-c-longjmp port c-exp)
   (write-char #\{ port)
   (display "__ContinueValue = " port)
   (emit-c-exp port (caddr c-exp))
   (write-char #\; port)
   (display "_longjmp( (JMP_BUF *)" port)
   (emit-c-exp port (cadr c-exp))
   (display ", (JMP_VAL)1 );" port)
   (write-char #\} port))

;*---------------------------------------------------------------------*/
;*    emit-c-jmpbuf->bobj ...                                          */
;*---------------------------------------------------------------------*/
(define (emit-c-jmpbuf->bobj port c-exp)
   (write-char #\( port)
   (write-char #\( port)
   (emit-c-type port 'bobj)
   (write-char #\) port)
   (emit-c-exp port (cadr c-exp))
   (write-char #\) port))

;*---------------------------------------------------------------------*/
;*    emit-c-shortjmp ...                                              */
;*---------------------------------------------------------------------*/
(define (emit-c-shortjmp port c-exp)
   (write-char #\{ port)
   (display "__ContinueValue = " port)
   (emit-c-exp port (caddr c-exp))
   (display "; goto " port)
   (display (cgen-c-label (local-info (cadr c-exp))) port)
   (write-char #\; port)
   (write-char #\} port))

;*---------------------------------------------------------------------*/
;*    emit-c-call ...                                                  */
;*---------------------------------------------------------------------*/
(define (emit-c-call port c-exp)
   (emit-c-exp port (cadr c-exp))
   (emit-c-list port (caddr c-exp)))


