;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.2/Beta/walk.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 16:26:07 1993                          */
;*    Last change :  Tue Apr 27 15:20:34 1993  (serrano)               */
;*                                                                     */
;*    On fait de la beta-reduction sur les variables locales.          */
;*    -------------------------------------------------------------    */
;*    Cette passe detruit les slots `info' des variables locales       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module beta_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    beta_vgraph
	    beta_beta)
   (export  (beta-walk tree)))

;*---------------------------------------------------------------------*/
;*    beta-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (beta-walk tree)
   (verbose "   . Beta" #\Newline)
   (start-partial-error "Beta")
   (let loop ((walk tree))
      (if (null? walk)
	   (begin
	      (fail-if-partial-error)
	      tree)
	   (let ((var (car walk)))
	      (enter-function (shape var))
	      ;; on commence par annoter l'arbre syntaxique.
	      (vgraph! (function-body (global-value var)) var)
	      ;; on marque les parametres formels
	      (vgraph-formals! (function-args (global-value var)))
	      ;; on fait la beta-reduction
	      (function-body-set! (global-value var)
				  (beta (function-body (global-value var))))
	      (leave-function)
	      (loop (cdr walk))))))

