;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.3/0cfa/tree.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 21 10:40:50 1993                          */
;*    Last change :  Wed Jun 23 15:38:45 1993  (serrano)               */
;*                                                                     */
;*    On ajoute et on retire les noeuds de la 0cfa                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_tree
   (import  tools_shape)
   (export  (add-0cfa-in-tree! tree)
	    (rm-0cfa-in-tree!  tree))
   (include "0cfa/app.sch"
	    "Tools/trace.sch"
	    "Var/variable.sch"))

;*---------------------------------------------------------------------*/
;*    add-0cfa-in-tree! ...                                            */
;*---------------------------------------------------------------------*/
(define (add-0cfa-in-tree! tree)
   (let loop ((walk tree))
      (if (null? walk)
	  'done
	  (let* ((var   (car walk))
		 (value (global-value var))
		 (body  (function-body value)))
	     (function-body-set! value (add-0cfa-in-def! body))
	     (loop (cdr walk))))))

;*---------------------------------------------------------------------*/
;*    add-0cfa-in-def! ...                                             */
;*---------------------------------------------------------------------*/
(define (add-0cfa-in-def! exp)
   (let loop ((exp exp))
      (match-case exp
	 (()
	  exp)
	 ((atom ?-)
	  exp)
	 ((quote ?-)
	  exp)
	 ((typed-case ?type ?test . ?clauses)
	  (set-car! (cddr exp) (loop test))
	  (let liip ((hook clauses))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! (cdr (car hook)) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
	 ((let ?bindings ?body)
	  (let liip ((hook bindings))
	     (if (null? hook)
		 (begin
		    (set-car! (cddr exp) (loop body))
		    exp)
		 (begin
		    (set-car! (cdar hook) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
	 ((labels ?bindings ?body)
	  (let liip ((hook bindings))
	     (if (null? hook)
		 (begin
		    (set-car! (cddr exp) (loop body))
		    exp)
		 (begin
		    (set-car! (cddar hook) (loop (caddr (car hook))))
		    (liip (cdr hook))))))
	 (else
	  (cond
	     ((or (eq? (car exp) 'funcall)
		  (eq? (car exp) 'apply)
		  (eq? (car exp) 'return-from)
		  (not (symbol? (car exp))))
	      (let liip ((app exp))
		 (if (null? app)
		     (begin
			(set-cdr! exp (cons (make-app) (cdr exp)))
			exp)
		     (begin
			(set-car! app (loop (car app)))
			(liip (cdr app))))))
	     (else
	      (let liip ((hook exp))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! hook (loop (car hook)))
			(liip (cdr hook)))))))))))

;*---------------------------------------------------------------------*/
;*    rm-0cfa-in-tree! ...                                             */
;*---------------------------------------------------------------------*/
(define (rm-0cfa-in-tree! tree)
    (let loop ((walk tree))
      (if (null? walk)
	  'done
	  (let* ((var   (car walk))
		 (value (global-value var))
		 (body  (function-body value)))
	     (function-body-set! value (rm-0cfa-in-def! body))
	     (loop (cdr walk))))))

;*---------------------------------------------------------------------*/
;*    rm-0cfa-in-def! ...                                              */
;*---------------------------------------------------------------------*/
(define (rm-0cfa-in-def! exp)
;*    (trace (loop 0cfa) "rm-0cfa-in-def!: " (shape exp) #\Newline)  */
   (let loop ((exp exp))
;*       (trace (loop 0cfa) "rm-0cfa-in-def!(loop): " (shape exp) #\Newline)  */
      (match-case exp
	 (()
	  exp)
	 ((atom ?-)
	  exp)
	 ((quote ?-)
	  exp)
	 ((typed-case ?type ?test . ?clauses)
	  (set-car! (cddr exp) (loop test))
	  (let liip ((hook clauses))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! (cdr (car hook)) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
	 ((let ?bindings ?body)
	  (let liip ((hook bindings))
	     (if (null? hook)
		 (begin
		    (set-car! (cddr exp) (loop body))
		    exp)
		 (begin
		    (set-car! (cdar hook) (loop (cadr (car hook))))
		    (liip (cdr hook))))))
	 ((labels ?bindings ?body)
	  (let liip ((hook bindings))
	     (if (null? hook)
		 (begin
		    (set-car! (cddr exp) (loop body))
		    exp)
		 (begin
		    (set-car! (cddar hook) (loop (caddr (car hook))))
		    (liip (cdr hook))))))
	 (else
	  (cond
	     ((or (eq? (car exp) 'funcall)
		  (eq? (car exp) 'apply)
		  (eq? (car exp) 'return-from)
		  (not (symbol? (car exp))))
	      (let liip ((app exp))
		 (if (null? app)
		     (begin 
			(set-cdr! exp (cddr exp))
			exp)
		     (begin
			(set-car! app (loop (car app)))
			(liip (cdr app))))))
	     (else
	      (let liip ((hook exp))
		 (if (null? hook)
		     exp
		     (begin
			(set-car! hook (loop (car hook)))
			(liip (cdr hook)))))))))))
      


		   
	  

