;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.3/0cfa/reduce.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May  9 10:03:34 1993                          */
;*    Last change :  Wed Jun 23 15:05:07 1993  (serrano)               */
;*                                                                     */
;*    On reduit le code en tirant parties des annotions qui ont ete    */
;*    faites.                                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_reduce
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "0cfa/0cfa.sch"
	    "0cfa/app.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    heap_abstract
	    0cfa_0cfa)
   (export  (0cfa-reduce-tree! tree)))

;*---------------------------------------------------------------------*/
;*    0cfa-reduce-tree! ...                                            */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce-tree! tree)
   (for-each
    (lambda (var)
       (trace (loop 0cfa)
	      ":::::::::::::::::::::::::::::::::::::::::::"
	      #\Newline
	      (shape var) #\Newline)
       (let ((fun (global-value var)))
	  (function-body-set! fun (0cfa-reduce! (function-body fun)
						'()))))
    tree))

;*---------------------------------------------------------------------*/
;*    0cfa-reduce! ...                                                 */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce! exp lenv)
   (trace (loop 0cfa) "0cfa-reduce!: " (shape exp) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- function --------------------------------------------------------*/
      ((function ?-)
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif ?si ?alors ?sinon)
       (set-car! (cdr exp) (0cfa-reduce! si lenv))
       (set-car! (cddr exp) (0cfa-reduce! alors lenv))
       (set-car! (cdddr exp) (0cfa-reduce! sinon lenv))
       exp)
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (0cfa-reduce! test lenv))
       (for-each (lambda (clause)
		    (set-car! (cdr clause) (0cfa-reduce! (cadr clause) lenv)))
		 clauses)
       exp)
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook) lenv))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?- ?val)
       (set-car! (cddr exp) (0cfa-reduce! val lenv))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((bindings bindings)
		  (new-lenv lenv))
	  (if (null? bindings)
	      (begin
		 (set-car! (cddr exp) (0cfa-reduce! body new-lenv))
		 exp)
	      (begin
		 (set-car! (cdr (car bindings))
			   (0cfa-reduce! (cadr (car bindings)) lenv))
		 (loop (cdr bindings)
		       (cons (car bindings) new-lenv))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let ((lenv (append (map car bindings) lenv)))
	  (let loop ((bindings bindings))
	     (if (null? bindings)
		 (begin
		    (set-car! (cddr exp) (0cfa-reduce! body lenv))
		    exp)
		 (begin
		    (set-car! (cddr (car bindings))
			      (0cfa-reduce! (caddr (car bindings))
					    (append (cadr (car bindings))
						    lenv)))
		    (loop (cdr bindings)))))))
;*--- block -----------------------------------------------------------*/
      ((block ?var ?body)
       (set-car! (cddr exp) (0cfa-reduce! body lenv))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from ?app-info ?escape ?value)
       (set-car! (cdddr exp) (0cfa-reduce! value lenv))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply ?app-info ?fun . ?args)
       (let loop ((hook args))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (0cfa-reduce! fun lenv))
		 exp)
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook) lenv))
		 (loop (cdr hook))))))
;*--- funcall ---------------------------------------------------------*/
      ((funcall ?app-info ?fun . ?args)
       (0cfa-reduce-funcall exp app-info fun args lenv))
;*--- application -----------------------------------------------------*/
      ((?fun ?app-info . ?args)
       (0cfa-reduce-app exp fun app-info args lenv))))
       
;*---------------------------------------------------------------------*/
;*    0cfa-reduce-funcall ...                                          */
;*    -------------------------------------------------------------    */
;*    Il y a deux facons de reduire un funcall:                        */
;*       1- on connait le resultat                                     */
;*       2- on connait la fonction sur laquelle porte l'application    */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce-funcall exp app-info fun args lenv)
   (trace (loop 0cfa) "==> funcall: " (shape exp) #\Newline
	              "    res*   : " (shape (app-res* app-info)) #\Newline
		      "    fun*   : " (shape (app-fun* app-info)) #\Newline)
   (cond
      ((and (pair? (app-res* app-info))
	    (null? (cdr (app-res* app-info)))
	    (memq  (car (app-res* app-info)) lenv))
       ;; on connait le resultat
       (trace (loop 0cfa) "<== res: " (shape (car (app-res* app-info)))
	      #\Newline)
       `(function ,(car (app-res* app-info))))
      (else
       (let loop ((hook args))
	  (if (null? hook)
	      (cond
		 ((and (pair? (app-fun* app-info))
		       (null? (cdr (app-fun* app-info)))
		       (memq (car (app-fun* app-info)) lenv))
		  ;; on connait la fonction
		  (trace (loop 0cfa) "<== fun: "
			 (shape (car (app-fun* app-info)))
			 #\Newline)
		  `(,(car (app-fun* app-info)) ,app-info ,@args))
		 (else
		  (set-car! (cddr exp) (0cfa-reduce! fun lenv))
		  exp))
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook) lenv))
		 (loop (cdr hook))))))))

;*---------------------------------------------------------------------*/
;*    0cfa-reduce-app ...                                              */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce-app exp fun app-info args lenv)
   (trace (loop 0cfa) "==> app: " (shape exp) #\Newline)
   (cond
      ((and (pair? (app-res* app-info))
	    (null? (cdr (app-res* app-info)))
	    (memq  (car (app-res* app-info)) lenv))
       ;; on connait le resultat
       (trace (loop 0cfa) "<== res: " (shape (car (app-res* app-info)))
	      #\Newline)
       `(function ,(car (app-res* app-info))))
      (else
       (let loop ((hook args))
	  (if (null? hook)
	      (begin
		 (if (type-tester? fun)
		     (pre-evaluate fun exp)
		     exp))
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook) lenv))
		 (loop (cdr hook))))))))

;*---------------------------------------------------------------------*/
;*    pre-evaluate ...                                                 */
;*---------------------------------------------------------------------*/
(define (pre-evaluate fun exp)
   (trace (loop 0cfa) "pre-evaluate: " (shape exp) #\Newline)
   (cond
      ((abstract-procedure-arity? fun)
       (let ((arg-approx (0cfa-exp! (caddr exp))))
	  (if (or (null? arg-approx)
		  (eq? arg-approx 'bottom))
	      exp
	      (let ((procedures-arity (procedures-arity arg-approx)))
		 (if (integer? procedures-arity)
		     procedures-arity
		     exp)))))
      ((abstract-procedure?? fun)
       (let ((arg-approx (0cfa-exp! (caddr exp))))
	  (if (or (null? arg-approx)
		  (eq? arg-approx 'bottom))
	      exp
	      (let ((test (and-all-approx (lambda (a)
					     (cond
						((local? a)
						 (function? (local-value a)))
						((global? a)
						 (function? (global-value a)))
						(else
						 '())))
					  arg-approx)))
		 (if (boolean? test)
		     test
		     exp)))))
      ((abstract-va-procedure?? fun)
       (let ((arg-approx (0cfa-exp! (caddr exp))))
	  (if (or (null? arg-approx)
		  (eq? arg-approx 'bottom))
	      exp
	      (let ((test (and-all-approx
			   (lambda (a)
			      (cond
				 ((local? a)
				  (and (function? (local-value a))
				       (<fx (function-arity (local-value a))
					    0)))
				 ((global? a)
				  (and (function? (global-value a))
				       (<fx (function-arity
					     (global-value a))
					    0)))
				 (else
				  '())))
			   arg-approx)))
		 (if (boolean? test)
		     test
		     exp)))))
      (else
       ;; les tester n'attendent tous qu'un seul argument.
       (let ((arg-approx (0cfa-exp! (caddr exp))))
	  (trace (loop 0cfa) "arg-approx: " (shape arg-approx) #\Newline)
	  (if (or (null? arg-approx)
		  (eq? arg-approx 'bottom)
		  (not (null? (cdr arg-approx))))
	      exp
	      (case (car arg-approx)
		 ((bobj)
		  exp)
		 ((bint)
		  (abstract-integer?? fun))
		 ((breal)
		  (abstract-real?? fun))
		 ((bpair)
		  (abstract-pair?? fun))
		 ((bchar)
		  (abstract-char?? fun))
		 ((bsymbol)
		  (abstract-symbol?? fun))
		 ((bstring)
		  (abstract-string?? fun))
		 ((bvector)
		  (abstract-vector?? fun))
		 ((binput-port)
		  (abstract-input-port?? fun))
		 ((boutput-port)
		  (abstract-output-port?? fun))
		 ((bstruct)
		  (abstract-struct?? fun))
		 (else
		  (cond
		     ((local? exp)
		      (if (or (eq? (local-class exp) 'function)
			      (eq? (local-class exp) 'return))
			  #f
			  exp))
		     ((global? exp)
		      (if (or (eq? (global-class exp) 'function)
			      (eq? (global-class exp) 'foreign))
			  #f
			  exp))))))))))
	  
;*---------------------------------------------------------------------*/
;*    type-tester? ...                                                 */
;*---------------------------------------------------------------------*/
(define (type-tester? fun)
   (and (global? fun)
	(eq? (global-import fun) 'foreign)
	(memq fun (abstract-type-tester))))

;*---------------------------------------------------------------------*/
;*    and-all-approx ...                                               */
;*---------------------------------------------------------------------*/
(define (and-all-approx tester approx*)
   (if (null? approx*)
       #t
       (let ((test (tester (car approx*))))
	  (cond
	     ((null? test)
	      '())
	     (test
	      (and-all-approx tester (cdr approx*)))
	     (else
	      #f)))))

;*---------------------------------------------------------------------*/
;*    procedures-arity ...                                             */
;*    -------------------------------------------------------------    */
;*    Si toutes les approximations ont la meme arite on la retourne.   */
;*    Sinon on retourne #f                                             */
;*---------------------------------------------------------------------*/
(define (procedures-arity arg-approx)
   (define (procedure-arity var)
      (cond
	 ((local? var)
	  (cond
	     ((eq? (local-class var) 'function)
	      (function-arity (local-value var)))
	     ((eq? (local-class var) 'return)
	      1)
	     (else
	      #f)))
	 ((global? var)
	  (if (eq? (global-class var) 'function)
	      (function-arity (global-value var))
	      #f))))
   (let ((arity (procedure-arity (car arg-approx))))
      (let loop ((approxs (cdr arg-approx)))
	 (cond
	    ((not (integer? arity))
	     #f)
	    ((null? approxs)
	     arity)
	    ((eq? (procedure-arity (car approxs)) arity)
	     (loop (cdr approxs)))
	    (else
	     #f)))))
		  
	 
	       
