;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.2/0cfa/0cfa.sch ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed May  5 16:10:07 1993                          */
;*    Last change :  Fri May  7 10:00:30 1993  (serrano)               */
;*                                                                     */
;*    La structure utilisee pour faire la 0cfa                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    variable ...                                                     */
;*---------------------------------------------------------------------*/
(define-struct _variable
   A*         ;;           : la liste des approximation d'une variable
   funcall?)  ;; { t, f }  : cette variable subit-elle un funcall ?

;*---------------------------------------------------------------------*/
;*    lambda ...                                                       */
;*---------------------------------------------------------------------*/
(define-struct _lambda
   site*     ;;           : les sites d'application d'une lambda
   stamp     ;; integer   : a quelle etape a-t-on evaluer le body ?
   body-A*)  ;; local*    : le resultat de l'approximation du corps
   
;*---------------------------------------------------------------------*/
;*    make-accessor ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (make-accessor class structure field)
   `(define ,(symbol-append class '- field)
       (lambda (var)
	  (,(symbol-append structure '- field)
	   (,(symbol-append class '-info) var)))))

;*---------------------------------------------------------------------*/
;*    make-seter ...                                                   */
;*---------------------------------------------------------------------*/
(define-macro (make-seter class structure field)
   `(define ,(symbol-append class '- field '-set!)
       (lambda (var value)
	  (,(symbol-append structure '- field '-set!)
	   (,(symbol-append class '-info) var)
	   value))))

;*---------------------------------------------------------------------*/
;*    make-accessor/seter ...                                          */
;*---------------------------------------------------------------------*/
(define-macro (make-accessor/seter class structure . field*)
   `(begin
       ,@(apply append
		(map (lambda (field)
			(list
			 `(make-accessor ,class ,structure ,field)
			 `(make-seter    ,class ,structure ,field)))
		     field*))))

;*---------------------------------------------------------------------*/
;*    tous les `accesseurs' et les `seteurs'                           */
;*---------------------------------------------------------------------*/
(make-accessor/seter local  _variable A* funcall?)
(make-accessor/seter global _variable A* funcall?)
(make-accessor/seter local  _lambda   site* stamp body-A*)
(make-accessor/seter global _lambda   site* stamp body-A*)
   
			  
