/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/benchmarks/wc/flex/wc.flex ...       */
/*                                                                     */
/*    Auteur      :  Manuel SERRANO                                    */
/*    Creation    :  Thu Jun  6 14:35:05 1991                          */
/*    Last change :  Tue Mar 16 14:28:36 1993  (serrano)               */
/*                                                                     */
/*    Un essai de word-count en Lex                                    */
/*---------------------------------------------------------------------*/

%{
#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>

#define yywrap() 1

#define TIMEUNIT 60.

int mchar, mline, mword;
%}

%%
\n+             { mchar += yyleng;
                  mline += yyleng; }
[ \t]+          { mchar += yyleng; }
[^\n \t]+       { mchar += yyleng; 
                  mword++; }
.               { printf( "Can't match [%s]\n", yytext ); }                  
%%             

/*---------------------------------------------------------------------*/
/*     main ...                                                        */
/*---------------------------------------------------------------------*/
main( argc, argv )
int argc;
char *argv[];
{
   FILE *new_in;

   if( !(new_in = fopen( "wc/txt/wc.txt", "r" )) )
   {
     puts( "***ERROR: Can't open file: wc/txt/wc.txt" );
     exit( -1 );
   }
   else
      yyin = new_in;

   mchar = mline = mword = 0;

   while( yylex() );

   fclose( new_in );

   if( (mchar == 1295490) && (mword == 113880) && (mline == 31305) )
      puts( "OK" );
   else
      puts( "ERROR" );
}

 
