(* Counts characters, lines and words in one or several files. *)

let chars = ref 0
and words = ref 0
and lines = ref 0
;;

type state = Inside_word | Outside_word;;

let count_channel in_channel =
  let rec count status =
    let c = input_char in_channel in
    incr chars;
    match c with
      `\n` ->
        incr lines; count Outside_word
    | ` ` | `\t` ->
        count Outside_word
    | _ ->
        if status = Outside_word then begin incr words; () end;
        count Inside_word
  in
    try
      count Outside_word
    with End_of_file ->
      ()
;;

try
  let ic = open_in "wc/txt/wc.txt" in
     count_channel ic;
     close_in ic;
     print_string "OK";
     print_newline()
with sys__Sys_error s ->
  print_string "I/O error: ";
  print_string s;
  print_newline()
;;
