;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/wc/bigloo/wc.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  1 14:02:23 1992                          */
;*    Last change :  Sat Mar  6 10:05:15 1993  (serrano)               */
;*                                                                     */
;*    L'eternel exemple de grammaire rationnelle : wc                  */
;*---------------------------------------------------------------------*/

(module wc
   (main main)
   (include "misc/bigloo.sch"))

;*---------------------------------------------------------------------*/
;*    Les variables globales                                           */
;*---------------------------------------------------------------------*/
(define *CHAR* 0)
(define *LINE* 0)
(define *WORD* 0)

;*---------------------------------------------------------------------*/
;*    la grammaire                                                     */
;*---------------------------------------------------------------------*/
(define wc (regular-grammar ()
	      ((+ #\Newline)
	       (set! *char* (+fx *char* (the-length)))
	       (set! *line* (+fx *line* (the-length)))
	       'keep)
	      ((+ (in #\space #\tab))
	       (set! *char* (+fx *char* (the-length)))
	       'keep)
	      ((+ (out #\newline #\space #\tab))
	       (set! *char* (+fx *char* (the-length)))
	       (set! *word* (+fx 1 *word*))
	       'keep)))
	      
;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat 1
	   (let* ((input-port (open-input-file "wc/txt/wc.txt")))
	      (if (not (input-port? input-port))
		  -2
		  (begin
		     (set! *char* 0)
		     (set! *line* 0)
		     (set! *word* 0)
		     (let loop ((s (read/rp wc input-port)))
			(if (eq? s 'keep)
			    (loop (read/rp wc input-port))
			    (begin
			       (close-input-port input-port)
			       (list *line* *word* *char*)))))))
	   '(31305 113880 1295490)))
	     
	
	      

			    


