(* Benchs sur la manipulation de vecteurs et les boucles *)
(* Fichier soli.ml Pierre Weis *)

(* Sur serveur spark (cornas):
cor: ../camlot soli.ml 
time a.out
3.2u 0.1s 0:03.32 101.2% 0+427k 0+0io 0pf+0w

cor: camlc soli.ml
cor: time a.out
71.0u 0.3s 1:11.40 99.9% 0+385k 0+0io 0pf+0w

Caml V3.1
Evaluation has needed: Runtime: 6.02s GC: 2.64s
*)
(* Pour Caml V3.1
#standard arith true;;
#fast arith true;;
*)

(* Pour Caml Light: inutile en V3.1 *)
let display_int i = print_int i; flush std_out
and display_string s = print_string s; flush std_out
and display_newline() = print_newline(); flush std_out;;

type peg = Out | Empty | Peg;;

let board =
        [|
          [| Out; Out; Out; Out; Out; Out; Out; Out; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Peg; Peg; Peg; Peg; Peg; Peg; Peg; Out|];
          [| Out; Peg; Peg; Peg; Empty; Peg; Peg; Peg; Out|];
          [| Out; Peg; Peg; Peg; Peg; Peg; Peg; Peg; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Out; Out; Out; Out; Out; Out; Out; Out|]
        |];;

let moves = make_vect 31 ([||] : int vect vect);;

let dir = [| [|0;1|]; [|1;0|]; [|0;-1|]; [|-1;0|] |];;

let counter = ref 0;;

exception Found;;

let rec solve m =

  counter:=!counter + 1;
  m == 31 & board.(4).(4) == Peg or
  (try
   if !counter mod 500 == 0 then display_int !counter;
   for i=1 to 7 do
    for j=1 to 7 do
     if board.(i).(j)==Peg then
      begin
       for k=0 to 3 do 
        let d1 = dir.(k).(0) in
        let d2 = dir.(k).(1) in
        let i1 = i+d1 in let i2 = i1+d1 in
        let j1 = j+d2 in let j2 = j1+d2 in
        if board.(i1).(j1)==Peg & board.(i2).(j2)==Empty then
          begin
           board.(i).(j) <- Empty;
           board.(i1).(j1) <- Empty;
           board.(i2).(j2) <- Peg;
           if solve(m+1) then
              (moves.(m) <- [| [| i; j |]; [| i2; j2 |] |];raise Found);
           board.(i).(j) <- Peg;
           board.(i1).(j1) <- Peg;
           board.(i2).(j2) <- Empty
          end
       done
      end
    done
   done;
   false
  with Found -> true);;

let rec print_board board =
 display_newline();
 for i=0 to 8 do
  for j=0 to 8 do
    print_peg board.(i).(j)
  done;
  display_newline()
 done

and print_peg = function
    Out -> display_string "_"
  | Empty -> display_string " "
  | Peg -> display_string "$";;

(* En V3.1
let init_board board =
 for i=0 to 8 do
  for j=0 to 8 do
    board.(i).(j) <- (
    when
       i=4  && j=4 -> Empty
     | i>=1 && i<=7 && j>=3 && j<=5 -> Peg
     | i>=3 && i<=5 && j>=1 && j<=7 -> Peg
     | _ -> Out)
  done
 done;;
*)
let init_board board =
 for i=0 to 8 do
  for j=0 to 8 do
    board.(i).(j) <- (
    if i=4  & j=4 then Empty else
    if i>=1 & i<=7 & j>=3 & j<=5 then Peg else
    if i>=3 & i<=5 & j>=1 & j<=7 then Peg else Out)
  done
 done;;

let main () =
    counter:=0;
    init_board board;
    for i = 0 to vect_length moves - 1 do moves.(i) <- [||] done;
    solve 0; print_board board;;

for i=0 to 9 do
main()
done;;
