(module soli
   (main main)
   (include "misc/bigloo.sch"))


(define board
   '#(#(0 0 0 0 0 0 0 0 0)
      #(0 0 0 1 1 1 0 0 0)
      #(0 0 0 1 1 1 0 0 0)
      #(0 1 1 1 1 1 1 1 0)
      #(0 1 1 1 2 1 1 1 0)
      #(0 1 1 1 1 1 1 1 0)
      #(0 0 0 1 1 1 0 0 0)
      #(0 0 0 1 1 1 0 0 0)
      #(0 0 0 0 0 0 0 0 0)))


(define moves (make-vector 31 '#()))

(define dir '#(#(0 1) #(1 0) #(0 -1) #(-1 0)))

(define counter 0)

(define-macro (for var min max . body)
   (let ((loop (gensym)))
      `(let ,loop ((,var ,min))
	    (if (<=fx ,var ,max)
		(begin
		   ,@body
		   (,loop (+fx ,var 1)))
		'done))))

(define-macro (vref v i j)
   `(vector-ref (vector-ref ,v ,i) ,j))

(define-macro (vset! v i j val)
   `(vector-set! (vector-ref ,v ,i) ,j ,val))

(define (solve m)
   (set! counter (+fx 1 counter))
   (or (and (=fx m 31) (eq? (vref board 4 4) '1))
       (bind-exit
	(found)
	(if (=fx (remainder counter 500) 0)
	    (display counter))
	(for
	   i 1 7
	   (for
	      j 1 7
	      (if (eq? (vref board i j) '1)
		  (begin
		     (for
			k 0 3
			(let ((d1 (vref dir k 0))
			      (d2 (vref dir k 1)))
			   (let* ((i1 (+fx i d1))
				  (i2 (+fx i1 d1))
				  (j1 (+fx j d2))
				  (j2 (+fx j1 d2)))
			      (if (and (eq? (vref board i1 j1) '1)
				       (eq? (vref board i2 j2) '2))
				  (begin
				     (vset! board i j '2)
				     (vset! board i1 j1 '2)
				     (vset! board i2 j2 '1)
				     (if (solve (+fx m 1))
					 (begin
					    (vector-set! moves m
							 `#( #(,i ,j)
							     #(,i2 ,j2)))
					    (found #t)))
				     (vset! board i j '1)
				     (vset! board i1 j1 '1)
				     (vset! board i2 j2 '2))))))))))
	#f)))

(define (print-board board)
   (newline)
   (for i 0 8
	(for j 0 8
	     (print-1 (vref board i j)))
	(newline)))

(define (print-1 s)
   (case s
      ((0) (display "_"))
      ((2) (display " "))
      ((1) (display "$"))))

(define (init-board board)
   (for i 0 8
	(for j 0 8
	     (vset! board i j
		    (cond
		       ((and (=fx i 4) (=fx j 4)) '2)
		       ((and (>=fx i 1) (<=fx i 7)
			     (>=fx j 3) (<=fx j 5)) '1)
		       ((and (>=fx i 3) (<=fx i 5)
			     (>=fx j 1) (<=fx j 7)) '1)
		       (else
			'0))))))

(define (run)
   (set! counter 0)
   (init-board board)
   (for i 0 (-fx (vector-length moves) 1)
	(vector-set! moves i '#()))
   (solve 0)
   (print-board board))

;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->integer (cadr argv))
	   (run)
	   #f))

				       
				       
					      
						      
