;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/read/t/read.t ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 22 16:17:03 1992                          */
;*    Last change :  Sat Mar  6 09:49:02 1993  (serrano)               */
;*                                                                     */
;*    Un essai de reader                                               */
;*---------------------------------------------------------------------*/

(herald t)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))
   
;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (let ((port (open-input-file "read/txt/read.txt")))
	      (let ((npair   0)
		    (nint    0)
		    (nstring 0)
		    (nvector 0)
		    (nchar   0)
		    (nsymbol 0)
		    (nmisc   0))
		 (if (not (input-port? port))
		     -2
		     (let loop ((sexp   (read port))
				(n      0))
			(if (eof-object? sexp)
			    (begin
			       (close-input-port port)
			       (list nsymbol
				     nchar
				     nvector
				     nstring
				     nint
				     npair
				     nmisc
				     n))
			    (begin
			       (cond
				  ((pair? sexp)
				   (set! npair (+fx 1 npair)))
				  ((integer? sexp)
				   (set! nint (+fx 1 nint)))
				  ((string? sexp)
				   (set! nstring (+fx 1 nstring)))
				  ((vector? sexp)
				   (set! nvector (+fx 1 nvector)))
				  ((char? sexp)
				   (set! nchar (+fx 1 nchar)))
				  ((symbol? sexp)
				   (set! nsymbol (+fx 1 nsymbol)))
				  (else
				   (set! nmisc (+fx 1 nmisc))))
			       (loop (read port)
				     (+fx 1 n))))))))
	   '(224 112 224 224 112 561 0 1457)))

