;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/queens/t/queens.t ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 12 09:22:31 1992                          */
;*    Last change :  Thu Mar  4 09:47:58 1993  (serrano)               */
;*                                                                     */
;*    La resolution des huits reine d'apres L. Augustsson (lml)        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(herald reine)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))
   
;*---------------------------------------------------------------------*/
;*    succ ...                                                         */
;*---------------------------------------------------------------------*/
(define (succ x)
   (fx+ 1 x))

;*---------------------------------------------------------------------*/
;*    my-map ...                                                       */
;*---------------------------------------------------------------------*/
(define (my-map f)
   (letrec ((map_rec (lambda (l)
			(cond ((null? l)
			       '())
			      (else
			       (cons (f (car l)) (map_rec (cdr l))))))))
      map_rec))

;*---------------------------------------------------------------------*/
;*    filter ...                                                       */
;*---------------------------------------------------------------------*/
(define (filter p l)
   (cond
      ((null? l)
       '())
      ((p (car l))
       (cons (car l) (filter p (cdr l))))
      (else
       (filter p (cdr l)))))

;*---------------------------------------------------------------------*/
;*    count ...                                                        */
;*---------------------------------------------------------------------*/
(define (count from to)
   (if (fx> from to)
       '()
       (cons from (count (succ from) to))))

;*---------------------------------------------------------------------*/
;*    concmap ...                                                      */
;*---------------------------------------------------------------------*/
(define (concmap f l)
   (if (null? l)
       '()
       (append (f (car l)) (concmap f (cdr l)))))

;*---------------------------------------------------------------------*/
;*    nsoln ...                                                        */
;*---------------------------------------------------------------------*/
(define (nsoln nq)
   (letrec ((safe (lambda (d x l)
		     (if (null? l)
			 '#t
			 (let ((q (car l)))
			    (and
			     (not (eq? x q))
			     (and (not (eq? x (fx+ q d)))
				  (and (not (eq? x (fx- q d))) 
				       (safe (fx+ d 1) x (cdr l))))))))))
      (let ((ok (lambda (l)
		   (if (null? l)
		       '#t
		       (safe 1 (car l) (cdr l))))))
	 (let ((pos_l (count 1 nq)))
	    (let ((testcol (lambda (b)
			      (filter ok ((my-map (lambda (q) (cons q b)))
					  pos_l)))))
	       (letrec ((gen (lambda (n)
				(if (eq? n 0)
				    '(())
				    (concmap testcol (gen (fx- n 1)))))))
		  (length (gen nq))))))))

;*---------------------------------------------------------------------*/
;*    nsoln_a ...                                                      */
;*---------------------------------------------------------------------*/
(define (nsoln_a nq)
   (letrec ((ok (lambda (l)
		   (if (null? l)
		       '#t
		       (let* ((x (car l))
			      (l (cdr l)))
			  (letrec ((safe
				    (lambda (x d l)
				       (if
					(null? l)
					'#t
					(let* ((q (car l))
					       (l (cdr l)))
					   (and
					    (not (eq? x q))
					    (and (not (eq? x (fx+ q d)))
						 (and (not (eq? x (fx- q d)))
						      (safe x (fx+ d 1) l)))))))))
			     (safe x 1 l)))))))
      (letrec ((gen (lambda (n)
		       (if (= n 0)
			   '(())
			   (concmap (lambda (b)
				       (filter ok
					       ((my-map (lambda (q) (cons q b)))
						(count 1 nq))))
				    (gen (fx- n 1)))))))
	 (length (gen nq)))))

(define (mprint . l)
   (for-each display l)
   (newline))
   
;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (cons (nsoln 9) (nsoln_a 9))
	   '(352 . 352)))
			     



