;*---------------------------------------------------------------------*/
;*    .../queens.sc ...                                                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 12 09:22:31 1992                          */
;*    Last change :  Sat Mar  6 11:12:37 1993  (serrano)               */
;*                                                                     */
;*    La resolution des huits reine d'apres L. Augustsson (lml)        */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module reine (main main))
(include "misc/scc.sch")

;*---------------------------------------------------------------------*/
;*    succ ...                                                         */
;*---------------------------------------------------------------------*/
(define (succ x)
   (+ 1 x))

;*---------------------------------------------------------------------*/
;*    my-map ...                                                       */
;*---------------------------------------------------------------------*/
(define (my-map f)
   (letrec ((map_rec (lambda (l)
			(cond ((null? l)
			       '())
			      (else
			       (cons (f (car l)) (map_rec (cdr l))))))))
      map_rec))

;*---------------------------------------------------------------------*/
;*    filter ...                                                       */
;*---------------------------------------------------------------------*/
(define (filter p l)
   (cond
      ((null? l)
       '())
      ((p (car l))
       (cons (car l) (filter p (cdr l))))
      (else
       (filter p (cdr l)))))

;*---------------------------------------------------------------------*/
;*    count ...                                                        */
;*---------------------------------------------------------------------*/
(define (count from to)
   (if (> from to)
       '()
       (cons from (count (succ from) to))))

;*---------------------------------------------------------------------*/
;*    concmap ...                                                      */
;*---------------------------------------------------------------------*/
(define (concmap f l)
   (if (null? l)
       '()
       (append (f (car l)) (concmap f (cdr l)))))

;*---------------------------------------------------------------------*/
;*    nsoln ...                                                        */
;*---------------------------------------------------------------------*/
(define (nsoln nq)
   (letrec ((safe (lambda (d x l)
		     (if (null? l)
			 #t
			 (let ((q (car l)))
			    (and
			     (not (eq? x q))
			     (and (not (eq? x (+ q d)))
				  (and (not (eq? x (- q d))) 
				       (safe (+ d 1) x (cdr l))))))))))
      (let ((ok (lambda (l)
		   (if (null? l)
		       #t
		       (safe 1 (car l) (cdr l))))))
	 (let ((pos_l (count 1 nq)))
	    (let ((testcol (lambda (b)
			      (filter ok ((my-map (lambda (q) (cons q b)))
					  pos_l)))))
	       (letrec ((gen (lambda (n)
				(if (eq? n 0)
				    '(())
				    (concmap testcol (gen (- n 1)))))))
		  (length (gen nq))))))))

;*---------------------------------------------------------------------*/
;*    nsoln_a ...                                                      */
;*---------------------------------------------------------------------*/
(define (nsoln_a nq)
   (letrec ((ok (lambda (l)
		   (if (null? l)
		       #t
		       (let* ((x (car l))
			      (l (cdr l)))
			  (letrec ((safe
				    (lambda (x d l)
				       (if
					(null? l)
					#t
					(let* ((q (car l))
					       (l (cdr l)))
					   (and
					    (not (eq? x q))
					    (and (not (eq? x (+ q d)))
						 (and (not (eq? x (- q d)))
						      (safe x (+ d 1) l)))))))))
			     (safe x 1 l)))))))
      (letrec ((gen (lambda (n)
		       (if (= n 0)
			   '(())
			   (concmap (lambda (b)
				       (filter ok
					       ((my-map (lambda (q) (cons q b)))
						(count 1 nq))))
				    (gen (- n 1)))))))
	 (length (gen nq)))))
		       
;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (cons (nsoln 9) (nsoln_a 9))
	   '(352 . 352)))

			     
	    



