;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File:         puzzle.sch
; Description:  PUZZLE benchmark
; Author:       Richard Gabriel, after Forrest Baskett
; Created:      12-Apr-85
; Modified:     12-Apr-85 14:20:23 (Bob Shaw)
;               11-Aug-87 (Will Clinger)
;               22-Jan-88 (Will Clinger)
; Language:     Scheme
; Status:       Public Domain
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(herald puzzle)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))
   
(define (iota n)
  (do ((n n (fx- n 1))
       (list '() (cons (fx- n 1) list)))
      ((zero? n) list)))

;;; PUZZLE -- Forest Baskett's Puzzle benchmark, originally written in Pascal.

(define size 511)
(define classmax 3)
(define typemax 12)

(define *iii* 0)
(define *kount* 0)
(define *d* 8)

(define *piececount* (make-vector (fx+ classmax 1) 0))
(define *class* (make-vector (fx+ typemax 1) 0))
(define *piecemax* (make-vector (fx+ typemax 1) 0))
(define *puzzle* (make-vector (fx+ size 1)))
(define *p* (make-vector (fx+ typemax 1)))
(for-each (lambda (i) (vector-set! *p* i (make-vector (fx+ size 1))))
          (iota (fx+ typemax 1)))

(define (fit i j)
  (let ((end (vector-ref *piecemax* i)))
    (do ((k 0 (fx+ k 1)))
        ((or (fx> k end)
             (and (vector-ref (vector-ref *p* i) k)
                  (vector-ref *puzzle* (fx+ j k))))
         (if (fx> k end) #t #f)))))

(define (place i j)
  (let ((end (vector-ref *piecemax* i)))
    (do ((k 0 (fx+ k 1)))
        ((fx> k end))
        (cond ((vector-ref (vector-ref *p* i) k)
               (vector-set! *puzzle* (fx+ j k) #t)
               #t)))
    (vector-set! *piececount*
                 (vector-ref *class* i)
                 (fx- (vector-ref *piececount* (vector-ref *class* i)) 1))
    (do ((k j (fx+ k 1)))
        ((or (fx> k size) (not (vector-ref *puzzle* k)))
         ;        (newline)
         ;        (display "*Puzzle* filled")
         (if (fx> k size) 0 k)))))

(define (puzzle-remove i j)
  (let ((end (vector-ref *piecemax* i)))
    (do ((k 0 (fx+ k 1)))
        ((fx> k end))
        (cond ((vector-ref (vector-ref *p* i) k)
               (vector-set! *puzzle* (fx+ j k) #f)
               #f)))
    (vector-set! *piececount*
                 (vector-ref *class* i)
                 (fx+ (vector-ref *piececount* (vector-ref *class* i)) 1))))


(define (trial j)
   (set! *kount* (fx+ *kount* 1))
   (iterate trial1 ((i 0))
      (cond
	 ((fx> i typemax)
	  '())
	 ((and (not (fx= (vector-ref *piececount* (vector-ref *class* i)) 0))
	       (fit i j))
	  (let ((k (place i j)))
	     (cond
		((or (trial k) (fx= k 0))
		 #t)
		(else
		 (puzzle-remove i j)
		 (trial1 (fx+ i 1))))))
	 (else
	  (trial1 (+ i 1))))))

(define (trial-output x y)
  (newline)
  (display (string-append "Piece "
                          (number->string x '(int))
                          " at "
                          (number->string y '(int))
                          ".")))

(define (definepiece iclass ii jj kk)
  (let ((index 0))
    (do ((i 0 (fx+ i 1)))
        ((fx> i ii))
        (do ((j 0 (fx+ j 1)))
            ((fx> j jj))
            (do ((k 0 (fx+ k 1)))
                ((fx> k kk))
                (set! index (fx+ i (* *d* (fx+ j (* *d* k)))))
                (vector-set! (vector-ref *p* *iii*) index  #t))))
    (vector-set! *class* *iii* iclass)
    (vector-set! *piecemax* *iii* index)
    (cond ((not (fx= *iii* typemax))
           (set! *iii* (fx+ *iii* 1))))))

(define (start)
  (do ((m 0 (fx+ m 1)))
      ((fx> m size))
      (vector-set! *puzzle* m #t))
  (do ((i 1 (fx+ i 1)))
      ((fx> i 5))
      (do ((j 1 (fx+ j 1)))
          ((fx> j 5))
          (do ((k 1 (fx+ k 1)))
              ((fx> k 5))
              (vector-set! *puzzle* (fx+ i (* *d* (fx+ j (* *d* k)))) #f))))
  (do ((i 0 (fx+ i 1)))
      ((fx> i typemax))
      (do ((m 0 (fx+ m 1)))
          ((fx> m size))
          (vector-set! (vector-ref *p* i) m #f)))
  (set! *iii* 0)
  (definePiece 0 3 1 0)
  (definePiece 0 1 0 3)
  (definePiece 0 0 3 1)
  (definePiece 0 1 3 0)
  (definePiece 0 3 0 1)
  (definePiece 0 0 1 3)
  
  (definePiece 1 2 0 0)
  (definePiece 1 0 2 0)
  (definePiece 1 0 0 2)
  
  (definePiece 2 1 1 0)
  (definePiece 2 1 0 1)
  (definePiece 2 0 1 1)
  
  (definePiece 3 1 1 1)
  
  (vector-set! *piececount* 0 13)
  (vector-set! *piececount* 1 3)
  (vector-set! *piececount* 2 1)
  (vector-set! *piececount* 3 1)
  (let ((m (fx+ (* *d* (fx+ *d* 1)) 1))
        (n 0))
    (cond ((fit 0 m) (set! n (place 0 m)))
          (else 'error))
    (cond ((trial n)
	   *kount*)
          (else 'failure))))

;;; call:  (start)

(define (main argv)
	(repeat 1
		(start)
		2005))
