;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/mul/scc/mul.sc ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 12 11:15:38 1992                          */
;*    Last change :  Tue Mar 16 16:00:35 1993  (serrano)               */
;*                                                                     */
;*    Une multuplication farfelue (Bernard)                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foo (main main))
(include "misc/scc.sch")

;*---------------------------------------------------------------------*/
;*    mul                                                              */
;*---------------------------------------------------------------------*/
(define (mul n m)
   (letrec ((zero (lambda (i) i))
	    (zerop (lambda (n) (n #t)))
	    (subone (lambda (n) (if (zerop n) n (n #f))))
	    (res (lambda (n) (if (zerop n) 0 (+ 1 (res (subone n))))))
	    (addone (lambda (n) (lambda (f) (if f #f n))))
	    (nmake (lambda (n) (if (= n 0) zero (addone (nmake (- n 1))))))
	    (nplus (lambda (m n) (if (zerop n)
				     m
				     (addone (nplus m (subone n))))))
	    (nmul (lambda (m n) (if (zerop n)
				    zero
				    (nplus m (nmul m (subone n)))))))
      (res (nmul (nmake m) (nmake n)))))

(define (main argv)
    (repeat (string->number (cadr argv))
	    (mul 25 37)
	    925))
  

