;*---------------------------------------------------------------------*/
;*    .../mul.scm ...                                                  */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May 12 11:15:38 1992                          */
;*    Last change :  Tue Mar 16 14:58:39 1993  (serrano)               */
;*                                                                     */
;*    Une multuplication farfelue (Bernard)                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module foo
   (main main)
   (include "misc/bigloo.sch"))

;*---------------------------------------------------------------------*/
;*    mult                                                             */
;*---------------------------------------------------------------------*/
(define (mult n m)
   (labels ((zero (i) i)
	    (zerop (n) (n #t))
	    (subone (n) (if (zerop n) n (n #f)))
	    (res (n) (if (zerop n) 0 (+fx 1 (res (subone n)))))
	    (addone (n) (lambda (f) (if f #f n)))
	    (nmake (n) (if (=fx n 0) zero (addone (nmake (-fx n 1)))))
	    (nplus (m n) (if (zerop n)
			     m
			     (addone (nplus m (subone n)))))
	    (nmul (m n) (if (zerop n)
			    zero
			    (nplus m (nmul m (subone n))))))
      (res (nmul (nmake m) (nmake n)))))

;*---------------------------------------------------------------------*/
;*    Les formes top-level                                             */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->integer (cadr argv))
	   (mult 25 37)
	   925))
