;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/misc/scc.sch ...          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar  4 09:51:23 1993                          */
;*    Last change :  Thu Mar  4 14:30:02 1993  (serrano)               */
;*                                                                     */
;*    Les macros pour `scc'                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     defmacro (for STOC) ...                                         */
;*---------------------------------------------------------------------*/
(define-macro defmacro 
   (lambda (form expander)
      (let ( (name '())
	     (args '())
	     (body '()) )
	 (let ((objaux (cdr form)))
	    (if 
	     (and 
	      (pair? objaux)
	      (let ((objaux (car objaux)))
		 (and 
		  (pair? objaux)
		  (begin
		     (set! name (car objaux))
		     (set! objaux (cdr objaux))
		     #t)
		  (begin
		     (set! args objaux)
		     #t)))
	      (begin
		 (set! objaux (cdr objaux))
		 #t)
	      (begin
		 (set! body objaux)
		 #t))
	     (expander
	      `(define-macro ,name
		  (lambda (form expander)
		     (expander
		      (apply (lambda ,args . ,body)
				(cdr form))
			     expander)))
	      expander)
	     (begin
		(display "Invalid form : ")
		(display form)
		(newline)
		#f) ) ) ) ) )

;*---------------------------------------------------------------------*/
;*    repeat ...                                                       */
;*---------------------------------------------------------------------*/
(defmacro (repeat n exp wanted)
   `(let _loop_ ((n ,n))
       (if (= n 1)
	   (if (equal? ,wanted ,exp)
	       (begin
		  (display 'ok)
		  (newline))
	       (begin
		  (display 'error)
		  (newline)))
	   (begin
	      ,exp 
	      (_loop_ (- n 1))))))

(defmacro (=fx x y)
   `(= ,x ,y))

(defmacro (+fx x y)
   `(+ ,x ,y))

(defmacro (-fx x y)
   `(- ,x ,y))

(defmacro (<fx x y)
   `(< ,x ,y))

(defmacro (>fx x y)
   `(> ,x ,y))

(defmacro (<=fx x y)
   `(<= ,x ,y))

(defmacro (>=fx x y)
   `(>= ,x ,y))

(define (print . l)
   (for-each display l)
   (newline))

(define (display* . l)
   (for-each display l))

(define (unspecified) 'unspecified)

(defmacro (string->integer n) `(string->number ,n))
