;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/mapcar/t/mapcar.t ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 20 15:41:50 1992                          */
;*    Last change :  Thu Mar  4 13:35:17 1993  (serrano)               */
;*                                                                     */
;*    Un test un peu complet: mapcar                                   */
;*---------------------------------------------------------------------*/

(herald mmapcar)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))

;*---------------------------------------------------------------------*/
;*    my-map ...                                                       */
;*---------------------------------------------------------------------*/
(define (my-map f l)
   (letrec ((loop (lambda (l)
		     (if (null? l)
			 '()
			 (cons (f (car l)) (loop (cdr l)))))))
      (loop l)))

;*---------------------------------------------------------------------*/
;*    my-mapcar ...                                                    */
;*---------------------------------------------------------------------*/
(define (my-mapcar f . l)
   (letrec ((loop (lambda (l)
		     (if (null? (car l))
			 '()
			 (cons (apply f (my-map car l))
			       (loop (my-map cdr l)))))))
      (loop l)))

;*---------------------------------------------------------------------*/
;*    le test ...                                                      */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat 10
	   (let ((r '()))
	      (letrec ((loop (lambda (n)
				(if (= n 0)
				    r
				    (begin
				       (set! r (my-mapcar (lambda (x y)
							     (fx+ x (fx+ y n)))
							  '(1 2 3 4 5)
							  '(6 7 8 9 0)))
				       (loop (fx- n 1)))))))
		 (loop 10000)))
	   '(8 10 12 14 6)))






