;*---------------------------------------------------------------------*/
;*    .../mapcar.sc ...                                                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 20 15:41:50 1992                          */
;*    Last change :  Thu Mar  4 13:34:20 1993  (serrano)               */
;*                                                                     */
;*    Un test un peu complet: mapcar                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module mapcar (main main))
(include "misc/scc.sch")

;*---------------------------------------------------------------------*/
;*    my-map ...                                                       */
;*---------------------------------------------------------------------*/
(define (my-map f l)
   (let loop ((l l))
      (if (null? l)
	  '()
	  (cons (f (car l)) (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    my-mapcar ...                                                    */
;*---------------------------------------------------------------------*/
(define (my-mapcar f . l)
   (let loop ((l l))
      (if (null? (car l))
	  '()
	  (cons (apply f (my-map car l))
		(loop (my-map cdr l))))))

;*---------------------------------------------------------------------*/
;*    le test ...                                                      */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->number (cadr argv))
	   (let ((r '()))
	      (let loop ((n 10000))
		 (if (= n 0)
		     r
		     (begin
			(set! r (my-mapcar (lambda (x y)
					      (+ x (+ y n)))
					   '(1 2 3 4 5)
					   '(6 7 8 9 0)))
			(loop (- n 1))))))
	   '(8 10 12 14 6)))






