;*---------------------------------------------------------------------*/
;*    .../mapcar.scm ...                                               */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Mar 20 15:41:50 1992                          */
;*    Last change :  Thu Mar  4 13:33:32 1993  (serrano)               */
;*                                                                     */
;*    Un test un peu complet: mmapcar                                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module mmapcar
   (include "misc/bigloo.sch")
   (main main))

;*---------------------------------------------------------------------*/
;*    mmap ...                                                         */
;*---------------------------------------------------------------------*/
(define (mmap f l)
   (let loop ((l l))
      (if (null? l)
	  '()
	  (cons (f (car l)) (loop (cdr l))))))

;*---------------------------------------------------------------------*/
;*    mmapcar ...                                                      */
;*---------------------------------------------------------------------*/
(define (mmapcar f . l)
   (let loop ((l l))
      (if (null? (car l))
	  '()
	  (cons (apply f (mmap car l))
		(loop (mmap cdr l))))))

;*---------------------------------------------------------------------*/
;*    le test ...                                                      */
;*---------------------------------------------------------------------*/
(define (main argv)
   (repeat (string->integer (cadr argv))
	   (let (r)
	      (let loop ((n 10000))
		 (if (=fx n 0)
		     r
		     (begin
			(set! r (mmapcar (lambda (x y)
					    (+fx x (+fx y n)))
					 '(1 2 3 4 5)
					 '(6 7 8 9 0)))
			(loop (-fx n 1))))))
	   '(8 10 12 14 6)))
	   





