;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/benchmarks/leval/t/leval.t ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Feb 10 08:35:54 1993                          */
;*    Last change :  Thu Mar  4 15:07:41 1993  (serrano)               */
;*                                                                     */
;*    L'evaluateur de Bigloo                                           */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(herald leval)

;*---------------------------------------------------------------------*/
;*    Les macros                                                       */
;*---------------------------------------------------------------------*/
(define-local-syntax (repeat n exp wanted)
   `(letrec ((_loop_ (lambda (n)
                        (if (fx= n 1)
                            (if (equal? ,wanted ,exp)
                                (mprint 'ok)
                                (mprint 'error))
                            (begin
                               ,exp
                               (_loop_ (fx- n 1)))))))
       (_loop_ ,n)))

(define-local-syntax (=fx x y)
                `(fx= ,x ,y))

(define-local-syntax (+fx x y)
                `(fx+ ,x ,y))

(define-local-syntax (-fx x y)
                `(fx- ,x ,y))

(define-local-syntax (<fx x y)
                `(fx< ,x ,y))

(define (mprint . v)
   (for-each display v)
   (newline))
;*---------------------------------------------------------------------*/
;*    fin des macros                                                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Les environments ...                                             */
;*---------------------------------------------------------------------*/
(define the-global-environment '())

(define (errow a b c)
   (mprint "*** ERROW: " a #\Newline b " -- " c))

;*---------------------------------------------------------------------*/
;*    ewal ...                                                         */
;*    sexp x env --> sexp                                              */
;*---------------------------------------------------------------------*/
(define (ewal exp . env)
   (for-each (lambda (x)
		((compile-define (car x) (cdr x)) '()))
	     env)
   (meaning (compile exp '() #f) '()))

;*---------------------------------------------------------------------*/
;*    meaning ...                                                      */
;*---------------------------------------------------------------------*/
(define (meaning pre-compiled-expression dynamic-env)
   (pre-compiled-expression dynamic-env))

;*---------------------------------------------------------------------*/
;*    compile ...                                                      */
;*    s-exp x env x { t, f } --> (lambda () ...)                       */
;*    -------------------------------------------------------------    */
;*    La phase d'expansion a genere une syntaxe correcte. On n'a donc  */
;*    plus du tout a la tester maintenant.                             */
;*---------------------------------------------------------------------*/
(define (compile exp env tail?)
   (cond
      ((not (pair? exp))
       (let ((atom exp))
	  (cond
	     ((symbol? atom)
	      (compile-ref (variable atom env) tail?))
	     (else
	      (compile-cnst atom tail?)))))
      ((eq? (car exp) 'module)
       (lambda (dynamic-env) (unspecified)))
      ((eq? (car exp) 'quote)
       (let ((cnst (cadr exp)))
	  (compile-cnst cnst tail?)))
      ((eq? (car exp) 'if)
       (let ((si (cadr exp))
	     (alors (caddr exp))
	     (sinon (cadddr exp)))
	  (compile-if (compile si env #f)
		      (compile alors env tail?)
		      (compile sinon env tail?))))
      ((eq? (car exp) 'begin)
       (let ((rest (cdr exp)))
	  (compile-begin rest env)))
      ((eq? (car exp) 'define)
       (let ((var (cadr exp))
	     (val (caddr exp)))
	  (compile-define var (compile val '() #f))))
      ((eq? (car exp) 'set!)
       (let ((var (cadr exp))
	     (val (caddr exp)))
	  (compile-set (variable var env) (compile val env #f))))
      ((eq? (car exp) 'lambda)
       (let ((formals (cadr exp))
	     (body    (caddr exp)))
	  (compile-lambda formals
			  (compile body (extend-env formals env) #t)
			  tail?)))
      ((not (pair? (car exp)))
       (let ((fun (car exp))
	     (args (cdr exp)))
	  (let ((actuals (map (lambda (a) (compile a env #f)) args)))
	     (cond
		((symbol? fun)
		 (let ((proc (variable fun env)))
		    (cond
		       ((global? proc)
			(compile-global-application proc
						    actuals
						    tail?))
		       (else
			(compile-application (compile-ref proc #f)
					     actuals
					     tail?)))))
		((compiled-procedure? fun)
		 (compile-compiled-application fun actuals tail?))
		(else
		 (errow "ewal" "Not a procedure" fun))))))
      (else
       (let ((fun (car exp))
	     (args (cdr exp)))
	  (let ((actuals (map (lambda (a) (compile a env #f)) args))
		(proc    (compile fun env #f)))
	     (compile-application proc actuals tail?))))))

;*---------------------------------------------------------------------*/
;*    variable ...                                                     */
;*---------------------------------------------------------------------*/
(define (variable symbol env)
   (let ((offset (let loop ((env   env)
			    (count 0))
		    (cond
		       ((null? env)
			#f)
		       ((eq? (car env) symbol)
			count)
		       (else
			(loop (cdr env) (+fx count 1)))))))
      (if offset
	  offset
	  (let ((global (assq symbol the-global-environment)))
	     (if (not global)
		 `#(,symbol)
		 global)))))

;*---------------------------------------------------------------------*/
;*    global? ...                                                      */
;*---------------------------------------------------------------------*/
(define (global? variable)
   (pair? variable))

;*---------------------------------------------------------------------*/
;*    dynamic? ...                                                     */
;*---------------------------------------------------------------------*/
(define (dynamic? variable)
   (vector? variable))

;*---------------------------------------------------------------------*/
;*    compile-ref ...                                                  */
;*---------------------------------------------------------------------*/
(define (compile-ref variable tail?)
   (cond
      ((global? variable)
       (lambda (dynamic-env) (cdr variable)))
      ((dynamic? variable)
       (lambda (dynamic-env) (let ((global (assq (vector-ref variable 0)
						 the-global-environment)))
				(if (not global)
				    (errow "ewal"
					   "Unbound variable"
					   (vector-ref variable 0))
				    (cdr global)))))
      (else
       (case variable
	  ((0)
	   (lambda (dynamic-env) (car dynamic-env)))
	  ((1)
	   (lambda (dynamic-env) (cadr dynamic-env)))
	  ((2)
	   (lambda (dynamic-env) (caddr dynamic-env)))
	  ((3)
	   (lambda (dynamic-env) (cadddr dynamic-env)))
	  (else
	   (lambda (dynamic-env)
	      (do ((i 0 (+fx i 1))
		   (env dynamic-env (cdr env)))
		    ((=fx i variable) (car env)))))))))

;*---------------------------------------------------------------------*/
;*    compile-set ...                                                  */
;*---------------------------------------------------------------------*/
(define (compile-set variable value)
   (cond
      ((global? variable)
       (lambda (dynamic-env) (update-global! variable value dynamic-env)))
      ((dynamic? variable)
       (lambda (dynamic-env)
	  (let ((global (assq (vector-ref variable 0)
			      the-global-environment)))
	     (if (not global)
		 (errow "ewal"
			"Unbound variable"
			(vector-ref variable 0))
		 (update-global! global value dynamic-env)))))
      (else
       (case variable
	  ((0)
	   (lambda (dynamic-env) (set-car! dynamic-env
					   (value dynamic-env))))
	  ((1)
	   (lambda (dynamic-env) (set-car! (cdr dynamic-env)
					   (value dynamic-env))))
	  ((2)
	   (lambda (dynamic-env) (set-car! (cddr dynamic-env)
					   (value dynamic-env))))
	  ((3)
	   (lambda (dynamic-env) (set-car! (cdddr dynamic-env)
					   (value dynamic-env))))
	  (else
	   (lambda (dynamic-env)
	      (do ((i 0 (+fx i 1))
		   (env dynamic-env (cdr env)))
		    ((=fx i variable) (set-car! env
						(value dynamic-env))))))))))
	
;*---------------------------------------------------------------------*/
;*    compile-cnst ...                                                 */
;*---------------------------------------------------------------------*/
(define (compile-cnst cnst tail?)
   (lambda (dynamic-env) cnst))

;*---------------------------------------------------------------------*/
;*    compile-if ...                                                   */
;*---------------------------------------------------------------------*/
(define (compile-if test then else)
   (lambda (dynamic-env) (if (test dynamic-env)
			     (then dynamic-env)
			     (else dynamic-env))))

;*---------------------------------------------------------------------*/
;*    compile-begin ...                                                */
;*---------------------------------------------------------------------*/
(define (compile-begin body env)
   (cond
      ((and (pair? body) (and (null? (cdr body))))
       ;; le cas degenere
       (let ((rest (compile (car body) env #t)))
	  (lambda (dynamic-env) (rest dynamic-env))))
      (else
       (let ((body (let loop ((rest body))
		      (cond
			 ((null? rest)
			  (errow "ewal" "Illegal form" body))
			 ((null? (cdr rest))
			  (cons (compile (car rest) env #t) '()))
			 (else
			  (cons (compile (car rest) env #f)
				(loop (cdr rest))))))))
	  (lambda (dynamic-env) (let _loop_ ((body body))
				   (if (null? (cdr body))
				       ((car body) dynamic-env)
				       (begin
					  ((car body) dynamic-env)
					  (_loop_ (cdr body))))))))))

;*---------------------------------------------------------------------*/
;*    init-the-global-environment! ...                                 */
;*---------------------------------------------------------------------*/
(define (linit-the-global-environment!)
   (if (pair? the-global-environment)
       'done
       ;; je ne peux pas utiliser de constante car quand cette fonction
       ;; sera appelle, je ne suis pas qu'elles soient initialisee.
       (set! the-global-environment (cons (cons #f #f) '()))))

;*---------------------------------------------------------------------*/
;*    compile-define ...                                               */
;*    -------------------------------------------------------------    */
;*    On ne rajoute pas en tete car elle contient la definition de     */
;*    `the-module-environment'. On rajoute donc en deuxieme.           */
;*---------------------------------------------------------------------*/
(define (compile-define var val)
   (lambda (dynamic-env)
      (let ((cell (assq var the-global-environment)))
	 (if (pair? cell)
	     (begin
		(mprint "*** WARNING:bigloo:ewal\nredefinition of variable -- "
		       var)
		(update-global! cell val dynamic-env))
	     (begin
		(set-cdr! the-global-environment
			  (cons (car the-global-environment)
				(cdr the-global-environment)))
		(set-car! the-global-environment
			  (cons var (val dynamic-env)))
		var)))))

;*---------------------------------------------------------------------*/
;*    define-primitive! ...                                            */
;*    -------------------------------------------------------------    */
;*    Cette fonction est juste une forme abregee de la precedente, qui */
;*    construit le `(lambda () ...)' absent                            */
;*---------------------------------------------------------------------*/
(define (ldefine-primitive! var val)
   (set-cdr! the-global-environment
	     (cons (car the-global-environment)
		   (cdr the-global-environment)))
   (set-car! the-global-environment (cons var val)))

;*---------------------------------------------------------------------*/
;*      update-global! ...                                             */
;*---------------------------------------------------------------------*/
(define (update-global! variable val dynamic-env)
   (set-cdr! variable (val dynamic-env))
   (car variable))

;*---------------------------------------------------------------------*/
;*    extend-env ...                                                   */
;*---------------------------------------------------------------------*/
(define (extend-env extend old-env)
   (let _loop_ ((extend extend))
      (cond
	 ((null? extend)
	  old-env)
	 ((not (pair? extend))
	  (cons extend old-env))
	 (else
	  (cons (car extend) (_loop_ (cdr extend)))))))

;*---------------------------------------------------------------------*/
;*    pair ...                                                         */
;*---------------------------------------------------------------------*/
(define (pair n l)
   (if (< n 0)
       (let loop ((n n)
		  (l l))
	  (cond
	     ((= -1 n)
	      #t)
	     ((not (pair? l))
	      #f)
	     (else
	      (loop (+ 1 n) (cdr l)))))
       (let loop ((n n)
		  (l l))
	  (cond
	     ((= 0 n)
	      (null? l))
	     ((not (pair? l))
	      #f)
	     (else
	      (loop (- n 1) (cdr l)))))))
	      
;*---------------------------------------------------------------------*/
;*    compile-lambda ...                                               */
;*---------------------------------------------------------------------*/
(define (compile-lambda formals body tail?)
   (cond
      ((null? formals)
       (lambda (dynamic-env)
	  (lambda ()
	     (body dynamic-env))))
      ((pair 1 formals)
       (lambda (dynamic-env)
	  (lambda (x)
	     (body (cons x dynamic-env)))))
      ((pair 2 formals)
       (lambda (dynamic-env)
	  (lambda (x y)
	     (body (cons x (cons y dynamic-env))))))
      ((pair 3 formals)
       (lambda (dynamic-env)
	  (lambda (x y z)
	     (body (cons x (cons y (cons z dynamic-env)))))))
      ((pair 4 formals)
       (lambda (dynamic-env)
	  (lambda (x y z t)
	     (body (cons x (cons y (cons z (cons z dynamic-env))))))))
      ((symbol? formals)
       (lambda (dynamic-env)
	  (lambda x
	     (body (cons x dynamic-env)))))
      ((pair -1 formals)
       (lambda (dynamic-env)
	  (lambda (x . y)
	     (body (cons x (cons y dynamic-env))))))
      ((pair -2 formals)
       (lambda (dynamic-env)
	  (lambda (x y . z)
	     (body (cons x (cons y (cons z dynamic-env)))))))
      ((pair -3 formals)
       (lambda (dynamic-env)
	  (lambda (x y z . t)
	     (body (cons x (cons y (cons z (cons z dynamic-env))))))))
      (else
       (lambda (dynamic-env)
	  (lambda x
	     (let ((new-env (let _loop_ ((actuals x)
					 (formals formals))
			       (cond
				  ((null? formals)
				   (if (not (null? actuals))
				       (errow "ewal"
					      "Too many arguments provided"
					      actuals)
				       dynamic-env))
				  ((null? actuals)
				   (errow "ewal"
					  "Too fee arguments provided"
					  formals))
				  ((not (pair? formals))
				   (cons actuals dynamic-env))
				  (else
				   (cons (car actuals)
					 (_loop_ (cdr actuals)
						 (cdr formals))))))))
		(body new-env)))))))

;*---------------------------------------------------------------------*/
;*    compile-global-application ...                                   */
;*---------------------------------------------------------------------*/
(define (compile-global-application proc actuals tail?)
   (case (length actuals)
      ((0)
       (lambda (dynamic-env) ((cdr proc))))
      ((1)
       (lambda (dynamic-env) ((cdr proc) ((car actuals) dynamic-env))))
      ((2)
       (lambda (dynamic-env) ((cdr proc) ((car actuals) dynamic-env)
					 ((cadr actuals) dynamic-env))))
      ((3)
       (lambda (dynamic-env) ((cdr proc) ((car actuals) dynamic-env)
					 ((cadr actuals) dynamic-env)
					 ((caddr actuals) dynamic-env))))
      ((4)
       (lambda (dynamic-env) ((cdr proc) ((car actuals) dynamic-env)
					 ((cadr actuals) dynamic-env)
					 ((caddr actuals) dynamic-env)
					 ((cadddr actuals) dynamic-env))))
      (else
       (lambda (dynamic-env)
	  (apply (cdr proc) (map (lambda (v) (v dynamic-env)) actuals))))))

;*---------------------------------------------------------------------*/
;*    compile-compiled-application ...                                 */
;*---------------------------------------------------------------------*/
(define (compile-compiled-application proc actuals tail?)
   (case (length actuals)
      ((0)
       (lambda (dynamic-env) (proc)))
      ((1)
       (lambda (dynamic-env) (proc ((car actuals) dynamic-env))))
      ((2)
       (lambda (dynamic-env) (proc ((car actuals) dynamic-env)
				   ((cadr actuals) dynamic-env))))
      ((3)
       (lambda (dynamic-env) (proc ((car actuals) dynamic-env)
				   ((cadr actuals) dynamic-env)
				   ((caddr actuals) dynamic-env))))
      ((4)
       (lambda (dynamic-env) (proc ((car actuals) dynamic-env)
				   ((cadr actuals) dynamic-env)
				   ((caddr actuals) dynamic-env)
				   ((cadddr actuals) dynamic-env))))
      (else
       (lambda (dynamic-env)
	  (apply proc (map (lambda (v) (v dynamic-env)) actuals))))))
   
;*---------------------------------------------------------------------*/
;*    compile-application ...                                          */
;*---------------------------------------------------------------------*/
(define (compile-application proc actuals tail?)
   (case (length actuals)
      ((0)
       (lambda (dynamic-env) ((proc dynamic-env))))
      ((1)
       (lambda (dynamic-env) ((proc dynamic-env)
			      ((car actuals) dynamic-env))))
      ((2)
       (lambda (dynamic-env) ((proc dynamic-env)
			      ((car actuals) dynamic-env)
			      ((cadr actuals) dynamic-env))))
      ((3)
       (lambda (dynamic-env) ((proc dynamic-env)
			      ((car actuals) dynamic-env)
			      ((cadr actuals) dynamic-env)
			      ((caddr actuals) dynamic-env))))
      ((4)
       (lambda (dynamic-env) ((proc dynamic-env)
			      ((car actuals) dynamic-env)
			      ((cadr actuals) dynamic-env)
			      ((caddr actuals) dynamic-env)
			      ((cadddr actuals) dynamic-env))))
      (else
       (lambda (dynamic-env)
	  (apply (proc dynamic-env) (map (lambda (v) (v dynamic-env))
					   actuals))))))

;*---------------------------------------------------------------------*/
;*    Les inits                                                        */
;*---------------------------------------------------------------------*/
(linit-the-global-environment!)

(ldefine-primitive! '+ fx+)
(ldefine-primitive! '- fx-)
(ldefine-primitive! '< fx<)
(ldefine-primitive! 'eq? eq?)
(ldefine-primitive! 'car car)
(ldefine-primitive! 'cdr cdr)
(ldefine-primitive! 'cons cons)
(ldefine-primitive! 'null? null?)
(ldefine-primitive! 'unspecified unspecified)

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (ewal '(define fib (lambda (x)
			 (if (< x 2)
			     1
			     (+ (fib (- x 1)) (fib (- x 2)))))))
   (repeat (string->number (cadr argv))
	   (ewal '(fib 20))
	   10946))

